/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.envoymobile.engine;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import io.envoyproxy.envoymobile.engine.AndroidJniLibrary;

@TargetApi(value=21)
public class AndroidNetworkMonitor
extends BroadcastReceiver {
    private static final int ENVOY_NET_GENERIC = 0;
    private static final int ENVOY_NET_WWAN = 1;
    private static final int ENVOY_NET_WLAN = 2;
    private static volatile AndroidNetworkMonitor instance = null;
    private ConnectivityManager connectivityManager;
    private ConnectivityManager.NetworkCallback networkCallback;
    private NetworkRequest networkRequest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(Context context) {
        if (instance != null) {
            return;
        }
        Class<AndroidNetworkMonitor> clazz = AndroidNetworkMonitor.class;
        synchronized (AndroidNetworkMonitor.class) {
            if (instance != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            instance = new AndroidNetworkMonitor(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private AndroidNetworkMonitor(Context context) {
        this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.networkRequest = new NetworkRequest.Builder().addCapability(12).build();
        this.networkCallback = new ConnectivityManager.NetworkCallback(){

            public void onAvailable(Network network) {
                AndroidNetworkMonitor.this.handleNetworkChange();
            }

            public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
                AndroidNetworkMonitor.this.handleNetworkChange();
            }

            public void onLosing(Network network, int maxMsToLive) {
                AndroidNetworkMonitor.this.handleNetworkChange();
            }

            public void onLost(Network network) {
                AndroidNetworkMonitor.this.handleNetworkChange();
            }
        };
        this.connectivityManager.registerNetworkCallback(this.networkRequest, this.networkCallback);
        context.registerReceiver((BroadcastReceiver)this, new IntentFilter(){
            {
                this.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            }
        });
    }

    public void onReceive(Context context, Intent intent) {
        this.handleNetworkChange();
    }

    private void handleNetworkChange() {
        NetworkInfo networkInfo = this.connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            AndroidJniLibrary.setPreferredNetwork(0);
            return;
        }
        switch (networkInfo.getType()) {
            case 0: {
                AndroidJniLibrary.setPreferredNetwork(1);
                return;
            }
            case 1: {
                AndroidJniLibrary.setPreferredNetwork(2);
                return;
            }
        }
        AndroidJniLibrary.setPreferredNetwork(0);
    }
}

