/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.envoymobile.engine;

import io.envoyproxy.envoymobile.engine.types.EnvoyHTTPFilterFactory;
import java.util.List;

public class EnvoyConfiguration {
    public final String statsDomain;
    public final Integer connectTimeoutSeconds;
    public final Integer dnsRefreshSeconds;
    public final Integer dnsFailureRefreshSecondsBase;
    public final Integer dnsFailureRefreshSecondsMax;
    public final List<EnvoyHTTPFilterFactory> httpFilterFactories;
    public final Integer statsFlushSeconds;
    public final String appVersion;
    public final String appId;
    public final String virtualClusters;

    public EnvoyConfiguration(String statsDomain, int connectTimeoutSeconds, int dnsRefreshSeconds, int dnsFailureRefreshSecondsBase, int dnsFailureRefreshSecondsMax, List<EnvoyHTTPFilterFactory> httpFilterFactories, int statsFlushSeconds, String appVersion, String appId, String virtualClusters) {
        this.statsDomain = statsDomain;
        this.connectTimeoutSeconds = connectTimeoutSeconds;
        this.dnsRefreshSeconds = dnsRefreshSeconds;
        this.dnsFailureRefreshSecondsBase = dnsFailureRefreshSecondsBase;
        this.dnsFailureRefreshSecondsMax = dnsFailureRefreshSecondsMax;
        this.httpFilterFactories = httpFilterFactories;
        this.statsFlushSeconds = statsFlushSeconds;
        this.appVersion = appVersion;
        this.appId = appId;
        this.virtualClusters = virtualClusters;
    }

    String resolveTemplate(String templateYAML, String filterTemplateYAML) {
        StringBuilder filterConfigBuilder = new StringBuilder();
        for (EnvoyHTTPFilterFactory filterFactory : this.httpFilterFactories) {
            String filterConfig = filterTemplateYAML.replace("{{ platform_filter_name }}", filterFactory.getFilterName());
            filterConfigBuilder.append(filterConfig);
        }
        String filterConfigChain = filterConfigBuilder.toString();
        String resolvedConfiguration = templateYAML.replace("{{ stats_domain }}", this.statsDomain).replace("{{ platform_filter_chain }}", filterConfigChain).replace("{{ connect_timeout_seconds }}", String.format("%s", this.connectTimeoutSeconds)).replace("{{ dns_refresh_rate_seconds }}", String.format("%s", this.dnsRefreshSeconds)).replace("{{ dns_failure_refresh_rate_seconds_base }}", String.format("%s", this.dnsFailureRefreshSecondsBase)).replace("{{ dns_failure_refresh_rate_seconds_max }}", String.format("%s", this.dnsFailureRefreshSecondsMax)).replace("{{ stats_flush_interval_seconds }}", String.format("%s", this.statsFlushSeconds)).replace("{{ device_os }}", "Android").replace("{{ app_version }}", this.appVersion).replace("{{ app_id }}", this.appId).replace("{{ virtual_clusters }}", this.virtualClusters);
        if (resolvedConfiguration.contains("{{")) {
            throw new ConfigurationException();
        }
        return resolvedConfiguration;
    }

    static class ConfigurationException
    extends RuntimeException {
        ConfigurationException() {
            super("Unresolved Template Key");
        }
    }
}

