/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.envoymobile.engine;

import io.envoyproxy.envoymobile.engine.JniBridgeUtility;
import io.envoyproxy.envoymobile.engine.JniLibrary;
import io.envoyproxy.envoymobile.engine.JvmCallbackContext;
import io.envoyproxy.envoymobile.engine.types.EnvoyHTTPCallbacks;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class EnvoyHTTPStream {
    private final long streamHandle;
    private final JvmCallbackContext callbacksContext;

    void start() {
        JniLibrary.startStream(this.streamHandle, this.callbacksContext);
    }

    public EnvoyHTTPStream(long streamHandle, EnvoyHTTPCallbacks callbacks) {
        this.streamHandle = streamHandle;
        this.callbacksContext = new JvmCallbackContext(callbacks);
    }

    public void sendHeaders(Map<String, List<String>> headers, boolean endStream) {
        JniLibrary.sendHeaders(this.streamHandle, JniBridgeUtility.toJniHeaders(headers), endStream);
    }

    public void sendData(ByteBuffer data, boolean endStream) {
        if (data.isDirect()) {
            JniLibrary.sendData(this.streamHandle, data, endStream);
        } else if (data.hasArray()) {
            JniLibrary.sendData(this.streamHandle, data.array(), endStream);
        } else {
            throw new UnsupportedOperationException("Unsupported ByteBuffer implementation.");
        }
    }

    public void sendTrailers(Map<String, List<String>> trailers) {
        JniLibrary.sendTrailers(this.streamHandle, JniBridgeUtility.toJniHeaders(trailers));
    }

    public int cancel() {
        return JniLibrary.resetStream(this.streamHandle);
    }
}

