/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.envoymobile.engine;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class JvmBridgeUtility {
    private Map<String, List<String>> headerAccumulator = null;
    private long headerCount = 0L;

    JvmBridgeUtility() {
    }

    void passHeader(byte[] key, byte[] value, boolean start) {
        String headerValue;
        String headerKey;
        if (start) {
            assert (this.headerAccumulator == null);
            assert (this.headerCount == 0L);
            this.headerAccumulator = new HashMap<String, List<String>>();
        }
        assert (this.headerAccumulator != null);
        try {
            headerKey = new String(key, "UTF-8");
            headerValue = new String(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        List<String> values = this.headerAccumulator.get(headerKey);
        if (values == null) {
            values = new ArrayList<String>(1);
            this.headerAccumulator.put(headerKey, values);
        }
        values.add(headerValue);
        ++this.headerCount;
    }

    Map<String, List<String>> retrieveHeaders() {
        Map<String, List<String>> headers = this.headerAccumulator;
        this.headerAccumulator = null;
        this.headerCount = 0L;
        return headers;
    }

    boolean validateCount(long headerCount) {
        return this.headerCount == headerCount;
    }
}

