/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.envoymobile.engine;

import io.envoyproxy.envoymobile.engine.JvmBridgeUtility;
import io.envoyproxy.envoymobile.engine.types.EnvoyHTTPCallbacks;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

class JvmCallbackContext {
    private final JvmBridgeUtility bridgeUtility = new JvmBridgeUtility();
    private final EnvoyHTTPCallbacks callbacks;

    public JvmCallbackContext(EnvoyHTTPCallbacks callbacks) {
        this.callbacks = callbacks;
    }

    void passHeader(byte[] key, byte[] value, boolean start) {
        this.bridgeUtility.passHeader(key, value, start);
    }

    public Object onResponseHeaders(long headerCount, final boolean endStream) {
        assert (this.bridgeUtility.validateCount(headerCount));
        final Map<String, List<String>> headers = this.bridgeUtility.retrieveHeaders();
        this.callbacks.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                JvmCallbackContext.this.callbacks.onHeaders(headers, endStream);
            }
        });
        return null;
    }

    public Object onResponseTrailers(long trailerCount) {
        assert (this.bridgeUtility.validateCount(trailerCount));
        final Map<String, List<String>> trailers = this.bridgeUtility.retrieveHeaders();
        this.callbacks.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                JvmCallbackContext.this.callbacks.onTrailers(trailers);
            }
        });
        return null;
    }

    public Object onResponseData(final byte[] data, final boolean endStream) {
        this.callbacks.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                ByteBuffer dataBuffer = ByteBuffer.wrap(data);
                JvmCallbackContext.this.callbacks.onData(dataBuffer, endStream);
            }
        });
        return null;
    }

    public Object onError(final int errorCode, final byte[] message, final int attemptCount) {
        this.callbacks.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                String errorMessage = new String(message);
                JvmCallbackContext.this.callbacks.onError(errorCode, errorMessage, attemptCount);
            }
        });
        return null;
    }

    public Object onCancel() {
        this.callbacks.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                JvmCallbackContext.this.callbacks.onCancel();
            }
        });
        return null;
    }
}

