/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.envoymobile.engine;

import io.envoyproxy.envoymobile.engine.JniBridgeUtility;
import io.envoyproxy.envoymobile.engine.JvmBridgeUtility;
import io.envoyproxy.envoymobile.engine.types.EnvoyHTTPFilter;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

class JvmFilterContext {
    private final JvmBridgeUtility bridgeUtility = new JvmBridgeUtility();
    private final EnvoyHTTPFilter filter;

    public JvmFilterContext(EnvoyHTTPFilter filter) {
        this.filter = filter;
    }

    public void passHeader(byte[] key, byte[] value, boolean start) {
        this.bridgeUtility.passHeader(key, value, start);
    }

    public Object onRequestHeaders(long headerCount, boolean endStream) {
        assert (this.bridgeUtility.validateCount(headerCount));
        Map<String, List<String>> headers = this.bridgeUtility.retrieveHeaders();
        return JvmFilterContext.toJniFilterHeadersStatus(this.filter.onRequestHeaders(headers, endStream));
    }

    public Object onRequestData(byte[] data, boolean endStream) {
        ByteBuffer dataBuffer = ByteBuffer.wrap(data);
        return this.filter.onRequestData(dataBuffer, endStream);
    }

    public Object onRequestTrailers(long trailerCount) {
        assert (this.bridgeUtility.validateCount(trailerCount));
        Map<String, List<String>> trailers = this.bridgeUtility.retrieveHeaders();
        return JvmFilterContext.toJniFilterHeadersStatus(this.filter.onRequestTrailers(trailers));
    }

    public Object onResponseHeaders(long headerCount, boolean endStream) {
        assert (this.bridgeUtility.validateCount(headerCount));
        Map<String, List<String>> headers = this.bridgeUtility.retrieveHeaders();
        return JvmFilterContext.toJniFilterHeadersStatus(this.filter.onResponseHeaders(headers, endStream));
    }

    public Object onResponseData(byte[] data, boolean endStream) {
        ByteBuffer dataBuffer = ByteBuffer.wrap(data);
        return this.filter.onResponseData(dataBuffer, endStream);
    }

    public Object onResponseTrailers(long trailerCount) {
        assert (this.bridgeUtility.validateCount(trailerCount));
        Map<String, List<String>> trailers = this.bridgeUtility.retrieveHeaders();
        return JvmFilterContext.toJniFilterHeadersStatus(this.filter.onResponseTrailers(trailers));
    }

    private static byte[][] toJniHeaders(Object headers) {
        return JniBridgeUtility.toJniHeaders((Map)headers);
    }

    private static Object[] toJniFilterHeadersStatus(Object[] result) {
        assert (result.length == 2);
        result[1] = JvmFilterContext.toJniHeaders(result[1]);
        return result;
    }
}

