/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.envoymobile.engine;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import io.envoyproxy.envoymobile.engine.EnvoyEngine;
import io.envoyproxy.envoymobile.engine.types.EnvoyNetworkType;
import java.util.Collections;

@TargetApi(value=21)
public class AndroidNetworkMonitor
extends BroadcastReceiver {
    private static final String PERMISSION_DENIED_STATS_ELEMENT = "android_permissions.network_state_denied";
    private static final int ENVOY_NET_GENERIC = 0;
    private static final int ENVOY_NET_WWAN = 1;
    private static final int ENVOY_NET_WLAN = 2;
    private static volatile AndroidNetworkMonitor instance = null;
    private int previousNetworkType = 8;
    private EnvoyEngine envoyEngine;
    private ConnectivityManager connectivityManager;
    private ConnectivityManager.NetworkCallback networkCallback;
    private NetworkRequest networkRequest;

    @VisibleForTesting
    public ConnectivityManager getConnectivityManager() {
        return this.connectivityManager;
    }

    public static AndroidNetworkMonitor getInstance() {
        assert (instance != null);
        return instance;
    }

    private AndroidNetworkMonitor(Context context, EnvoyEngine envoyEngine) {
        int permission2 = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_NETWORK_STATE");
        if (permission2 == -1) {
            try {
                envoyEngine.recordCounterInc(PERMISSION_DENIED_STATS_ELEMENT, Collections.emptyMap(), 1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        this.envoyEngine = envoyEngine;
        this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.networkRequest = new NetworkRequest.Builder().addCapability(12).build();
        this.networkCallback = new ConnectivityManager.NetworkCallback(){

            public void onAvailable(Network network) {
                AndroidNetworkMonitor.this.handleNetworkChange();
            }

            public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
                AndroidNetworkMonitor.this.handleNetworkChange();
            }

            public void onLosing(Network network, int maxMsToLive) {
                AndroidNetworkMonitor.this.handleNetworkChange();
            }

            public void onLost(Network network) {
                AndroidNetworkMonitor.this.handleNetworkChange();
            }
        };
        try {
            this.connectivityManager.registerNetworkCallback(this.networkRequest, this.networkCallback);
            context.registerReceiver((BroadcastReceiver)this, new IntentFilter(){
                {
                    this.addAction("android.net.conn.CONNECTIVITY_CHANGE");
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void handleNetworkChange() {
        int networkType;
        NetworkInfo networkInfo = this.connectivityManager.getActiveNetworkInfo();
        int n = networkType = networkInfo == null ? -1 : networkInfo.getType();
        if (networkType == this.previousNetworkType) {
            return;
        }
        this.previousNetworkType = networkType;
        switch (networkType) {
            case 0: {
                this.envoyEngine.setPreferredNetwork(EnvoyNetworkType.ENVOY_NETWORK_TYPE_WWAN);
                return;
            }
            case 1: {
                this.envoyEngine.setPreferredNetwork(EnvoyNetworkType.ENVOY_NETWORK_TYPE_WLAN);
                return;
            }
        }
        this.envoyEngine.setPreferredNetwork(EnvoyNetworkType.ENVOY_NETWORK_TYPE_GENERIC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(Context context, EnvoyEngine envoyEngine) {
        if (instance != null) {
            return;
        }
        Class<AndroidNetworkMonitor> clazz = AndroidNetworkMonitor.class;
        synchronized (AndroidNetworkMonitor.class) {
            if (instance != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            instance = new AndroidNetworkMonitor(context, envoyEngine);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void onReceive(Context context, Intent intent) {
        this.handleNetworkChange();
    }

    public boolean isOnline() {
        return this.previousNetworkType != -1;
    }
}

