/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.envoymobile.engine;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.ProxyInfo;
import android.net.Uri;
import android.os.Bundle;
import io.envoyproxy.envoymobile.engine.EnvoyEngine;

@TargetApi(value=21)
class AndroidProxyMonitor
extends BroadcastReceiver {
    static volatile AndroidProxyMonitor instance = null;
    private ConnectivityManager connectivityManager;
    private EnvoyEngine envoyEngine;

    private ProxyInfo extractProxyInfo(Intent intent) {
        ProxyInfo info = this.connectivityManager.getDefaultProxy();
        if (info == null) {
            return null;
        }
        if (info.getPacFileUrl() != null && info.getPacFileUrl() != Uri.EMPTY) {
            if (intent == null) {
                return null;
            }
            Bundle extras = intent.getExtras();
            if (extras == null) {
                return null;
            }
            info = (ProxyInfo)extras.get("android.intent.extra.PROXY_INFO");
        }
        return info;
    }

    private AndroidProxyMonitor(Context context, EnvoyEngine envoyEngine) {
        this.envoyEngine = envoyEngine;
        this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.handleProxyChange(null);
        this.registerReceiver(context);
    }

    private void handleProxyChange(Intent intent) {
        ProxyInfo info = this.extractProxyInfo(intent);
        if (info == null) {
            this.envoyEngine.setProxySettings("", 0);
        } else {
            this.envoyEngine.setProxySettings(info.getHost(), info.getPort());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void load(Context context, EnvoyEngine envoyEngine) {
        if (instance != null) {
            return;
        }
        Class<AndroidProxyMonitor> clazz = AndroidProxyMonitor.class;
        synchronized (AndroidProxyMonitor.class) {
            if (instance != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            instance = new AndroidProxyMonitor(context, envoyEngine);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void onReceive(Context context, Intent intent) {
        this.handleProxyChange(intent);
    }

    private void registerReceiver(Context context) {
        context.getApplicationContext().registerReceiver((BroadcastReceiver)this, new IntentFilter(){
            {
                this.addAction("android.intent.action.PROXY_CHANGE");
            }
        });
    }
}

