/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.envoymobile.engine;

import com.google.protobuf.Struct;
import io.envoyproxy.envoymobile.engine.EnvoyNativeFilterConfig;
import io.envoyproxy.envoymobile.engine.JniBridgeUtility;
import io.envoyproxy.envoymobile.engine.JniLibrary;
import io.envoyproxy.envoymobile.engine.types.EnvoyHTTPFilterFactory;
import io.envoyproxy.envoymobile.engine.types.EnvoyKeyValueStore;
import io.envoyproxy.envoymobile.engine.types.EnvoyStringAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class EnvoyConfiguration {
    private static final Pattern UNRESOLVED_KEY_PATTERN = Pattern.compile("\\{\\{ (.+) \\}\\}");
    public final Integer connectTimeoutSeconds;
    public final Integer dnsRefreshSeconds;
    public final Integer dnsFailureRefreshSecondsBase;
    public final Integer dnsFailureRefreshSecondsMax;
    public final Integer dnsQueryTimeoutSeconds;
    public final Integer dnsMinRefreshSeconds;
    public final List<String> dnsPreresolveHostnames;
    public final Boolean enableDNSCache;
    public final Integer dnsCacheSaveIntervalSeconds;
    public final Boolean enableDrainPostDnsRefresh;
    public final Boolean enableHttp3;
    public final String http3ConnectionOptions;
    public final String http3ClientConnectionOptions;
    public final Map<String, String> quicHints;
    public final List<String> quicCanonicalSuffixes;
    public final Boolean enableGzipDecompression;
    public final Boolean enableBrotliDecompression;
    public final Boolean enableSocketTagging;
    public final Boolean enableInterfaceBinding;
    public final Integer h2ConnectionKeepaliveIdleIntervalMilliseconds;
    public final Integer h2ConnectionKeepaliveTimeoutSeconds;
    public final Integer maxConnectionsPerHost;
    public final List<EnvoyHTTPFilterFactory> httpPlatformFilterFactories;
    public final Integer streamIdleTimeoutSeconds;
    public final Integer perTryIdleTimeoutSeconds;
    public final String appVersion;
    public final String appId;
    public final TrustChainVerification trustChainVerification;
    public final List<EnvoyNativeFilterConfig> nativeFilterChain;
    public final Map<String, EnvoyStringAccessor> stringAccessors;
    public final Map<String, EnvoyKeyValueStore> keyValueStores;
    public final Map<String, String> runtimeGuards;
    public final Boolean enablePlatformCertificatesValidation;
    public final String rtdsResourceName;
    public final Integer rtdsTimeoutSeconds;
    public final String xdsAddress;
    public final Integer xdsPort;
    public final Map<String, String> xdsGrpcInitialMetadata;
    public final String xdsRootCerts;
    public final String nodeId;
    public final String nodeRegion;
    public final String nodeZone;
    public final String nodeSubZone;
    public final Struct nodeMetadata;
    public final String cdsResourcesLocator;
    public final Integer cdsTimeoutSeconds;
    public final Boolean enableCds;

    public long createBootstrap() {
        Boolean enforceTrustChainVerification = this.trustChainVerification == TrustChainVerification.VERIFY_TRUST_CHAIN;
        ArrayList<EnvoyNativeFilterConfig> reverseFilterChain = new ArrayList<EnvoyNativeFilterConfig>(this.nativeFilterChain);
        Collections.reverse(reverseFilterChain);
        byte[][] filterChain = JniBridgeUtility.toJniBytes(reverseFilterChain);
        byte[][] dnsPreresolve = JniBridgeUtility.stringsToJniBytes(this.dnsPreresolveHostnames);
        byte[][] runtimeGuards = JniBridgeUtility.mapToJniBytes(this.runtimeGuards);
        byte[][] quicHints = JniBridgeUtility.mapToJniBytes(this.quicHints);
        byte[][] quicSuffixes = JniBridgeUtility.stringsToJniBytes(this.quicCanonicalSuffixes);
        byte[][] xdsGrpcInitialMetadata = JniBridgeUtility.mapToJniBytes(this.xdsGrpcInitialMetadata);
        return JniLibrary.createBootstrap(this.connectTimeoutSeconds.intValue(), this.dnsRefreshSeconds.intValue(), this.dnsFailureRefreshSecondsBase.intValue(), this.dnsFailureRefreshSecondsMax.intValue(), this.dnsQueryTimeoutSeconds.intValue(), this.dnsMinRefreshSeconds.intValue(), dnsPreresolve, this.enableDNSCache, this.dnsCacheSaveIntervalSeconds.intValue(), this.enableDrainPostDnsRefresh, this.enableHttp3, this.http3ConnectionOptions, this.http3ClientConnectionOptions, quicHints, quicSuffixes, this.enableGzipDecompression, this.enableBrotliDecompression, this.enableSocketTagging, this.enableInterfaceBinding, this.h2ConnectionKeepaliveIdleIntervalMilliseconds.intValue(), this.h2ConnectionKeepaliveTimeoutSeconds.intValue(), this.maxConnectionsPerHost.intValue(), this.streamIdleTimeoutSeconds.intValue(), this.perTryIdleTimeoutSeconds.intValue(), this.appVersion, this.appId, enforceTrustChainVerification, filterChain, this.enablePlatformCertificatesValidation, runtimeGuards, this.rtdsResourceName, this.rtdsTimeoutSeconds.intValue(), this.xdsAddress, this.xdsPort.intValue(), xdsGrpcInitialMetadata, this.xdsRootCerts, this.nodeId, this.nodeRegion, this.nodeZone, this.nodeSubZone, this.nodeMetadata.toByteArray(), this.cdsResourcesLocator, this.cdsTimeoutSeconds.intValue(), this.enableCds);
    }

    public EnvoyConfiguration(int connectTimeoutSeconds, int dnsRefreshSeconds, int dnsFailureRefreshSecondsBase, int dnsFailureRefreshSecondsMax, int dnsQueryTimeoutSeconds, int dnsMinRefreshSeconds, List<String> dnsPreresolveHostnames, boolean enableDNSCache, int dnsCacheSaveIntervalSeconds, boolean enableDrainPostDnsRefresh, boolean enableHttp3, String http3ConnectionOptions, String http3ClientConnectionOptions, Map<String, Integer> quicHints, List<String> quicCanonicalSuffixes, boolean enableGzipDecompression, boolean enableBrotliDecompression, boolean enableSocketTagging, boolean enableInterfaceBinding, int h2ConnectionKeepaliveIdleIntervalMilliseconds, int h2ConnectionKeepaliveTimeoutSeconds, int maxConnectionsPerHost, int streamIdleTimeoutSeconds, int perTryIdleTimeoutSeconds, String appVersion, String appId, TrustChainVerification trustChainVerification, List<EnvoyNativeFilterConfig> nativeFilterChain, List<EnvoyHTTPFilterFactory> httpPlatformFilterFactories, Map<String, EnvoyStringAccessor> stringAccessors, Map<String, EnvoyKeyValueStore> keyValueStores, Map<String, Boolean> runtimeGuards, boolean enablePlatformCertificatesValidation, String rtdsResourceName, Integer rtdsTimeoutSeconds, String xdsAddress, Integer xdsPort, Map<String, String> xdsGrpcInitialMetadata, String xdsRootCerts, String nodeId, String nodeRegion, String nodeZone, String nodeSubZone, Struct nodeMetadata, String cdsResourcesLocator, Integer cdsTimeoutSeconds, boolean enableCds) {
        JniLibrary.load();
        this.connectTimeoutSeconds = connectTimeoutSeconds;
        this.dnsRefreshSeconds = dnsRefreshSeconds;
        this.dnsFailureRefreshSecondsBase = dnsFailureRefreshSecondsBase;
        this.dnsFailureRefreshSecondsMax = dnsFailureRefreshSecondsMax;
        this.dnsQueryTimeoutSeconds = dnsQueryTimeoutSeconds;
        this.dnsMinRefreshSeconds = dnsMinRefreshSeconds;
        this.dnsPreresolveHostnames = dnsPreresolveHostnames;
        this.enableDNSCache = enableDNSCache;
        this.dnsCacheSaveIntervalSeconds = dnsCacheSaveIntervalSeconds;
        this.enableDrainPostDnsRefresh = enableDrainPostDnsRefresh;
        this.enableHttp3 = enableHttp3;
        this.http3ConnectionOptions = http3ConnectionOptions;
        this.http3ClientConnectionOptions = http3ClientConnectionOptions;
        this.quicHints = new HashMap<String, String>();
        for (Map.Entry<String, Integer> hostAndPort : quicHints.entrySet()) {
            this.quicHints.put(hostAndPort.getKey(), String.valueOf(hostAndPort.getValue()));
        }
        this.quicCanonicalSuffixes = quicCanonicalSuffixes;
        this.enableGzipDecompression = enableGzipDecompression;
        this.enableBrotliDecompression = enableBrotliDecompression;
        this.enableSocketTagging = enableSocketTagging;
        this.enableInterfaceBinding = enableInterfaceBinding;
        this.h2ConnectionKeepaliveIdleIntervalMilliseconds = h2ConnectionKeepaliveIdleIntervalMilliseconds;
        this.h2ConnectionKeepaliveTimeoutSeconds = h2ConnectionKeepaliveTimeoutSeconds;
        this.maxConnectionsPerHost = maxConnectionsPerHost;
        this.streamIdleTimeoutSeconds = streamIdleTimeoutSeconds;
        this.perTryIdleTimeoutSeconds = perTryIdleTimeoutSeconds;
        this.appVersion = appVersion;
        this.appId = appId;
        this.trustChainVerification = trustChainVerification;
        int index = 0;
        for (EnvoyHTTPFilterFactory envoyHTTPFilterFactory : httpPlatformFilterFactories) {
            String config = "{'@type': type.googleapis.com/envoymobile.extensions.filters.http.platform_bridge.PlatformBridge, platform_filter_name: " + envoyHTTPFilterFactory.getFilterName() + "}";
            EnvoyNativeFilterConfig ins = new EnvoyNativeFilterConfig("envoy.filters.http.platform_bridge", config);
            nativeFilterChain.add(index++, ins);
        }
        this.nativeFilterChain = nativeFilterChain;
        this.httpPlatformFilterFactories = httpPlatformFilterFactories;
        this.stringAccessors = stringAccessors;
        this.keyValueStores = keyValueStores;
        this.runtimeGuards = new HashMap<String, String>();
        for (Map.Entry entry : runtimeGuards.entrySet()) {
            this.runtimeGuards.put((String)entry.getKey(), String.valueOf(entry.getValue()));
        }
        this.enablePlatformCertificatesValidation = enablePlatformCertificatesValidation;
        this.rtdsResourceName = rtdsResourceName;
        this.rtdsTimeoutSeconds = rtdsTimeoutSeconds;
        this.xdsAddress = xdsAddress;
        this.xdsPort = xdsPort;
        this.xdsGrpcInitialMetadata = new HashMap<String, String>(xdsGrpcInitialMetadata);
        this.xdsRootCerts = xdsRootCerts;
        this.nodeId = nodeId;
        this.nodeRegion = nodeRegion;
        this.nodeZone = nodeZone;
        this.nodeSubZone = nodeSubZone;
        this.nodeMetadata = nodeMetadata;
        this.cdsResourcesLocator = cdsResourcesLocator;
        this.cdsTimeoutSeconds = cdsTimeoutSeconds;
        this.enableCds = enableCds;
    }

    public static enum TrustChainVerification {
        VERIFY_TRUST_CHAIN,
        ACCEPT_UNTRUSTED;

    }

    static class ConfigurationException
    extends RuntimeException {
        ConfigurationException(String unresolvedKey) {
            super("Unresolved template key: " + unresolvedKey);
        }
    }
}

