/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.envoymobile.engine;

import io.envoyproxy.envoymobile.engine.EnvoyConfiguration;
import io.envoyproxy.envoymobile.engine.EnvoyEngine;
import io.envoyproxy.envoymobile.engine.EnvoyHTTPStream;
import io.envoyproxy.envoymobile.engine.JniBridgeUtility;
import io.envoyproxy.envoymobile.engine.JniLibrary;
import io.envoyproxy.envoymobile.engine.JvmFilterFactoryContext;
import io.envoyproxy.envoymobile.engine.JvmKeyValueStoreContext;
import io.envoyproxy.envoymobile.engine.JvmStringAccessorContext;
import io.envoyproxy.envoymobile.engine.types.EnvoyEventTracker;
import io.envoyproxy.envoymobile.engine.types.EnvoyHTTPCallbacks;
import io.envoyproxy.envoymobile.engine.types.EnvoyHTTPFilterFactory;
import io.envoyproxy.envoymobile.engine.types.EnvoyKeyValueStore;
import io.envoyproxy.envoymobile.engine.types.EnvoyLogger;
import io.envoyproxy.envoymobile.engine.types.EnvoyNetworkType;
import io.envoyproxy.envoymobile.engine.types.EnvoyOnEngineRunning;
import io.envoyproxy.envoymobile.engine.types.EnvoyStatus;
import io.envoyproxy.envoymobile.engine.types.EnvoyStringAccessor;
import java.util.Map;

public class EnvoyEngineImpl
implements EnvoyEngine {
    private static final int ENVOY_NET_GENERIC = 0;
    private static final int ENVOY_NET_WWAN = 1;
    private static final int ENVOY_NET_WLAN = 2;
    private final long engineHandle;

    @Override
    public int recordCounterInc(String elements, Map<String, String> tags, int count) {
        return JniLibrary.recordCounterInc(this.engineHandle, elements, JniBridgeUtility.toJniTags(tags), count);
    }

    @Override
    public int registerStringAccessor(String accessor_name, EnvoyStringAccessor accessor) {
        return JniLibrary.registerStringAccessor(accessor_name, new JvmStringAccessorContext(accessor));
    }

    @Override
    public EnvoyHTTPStream startStream(EnvoyHTTPCallbacks callbacks, boolean explicitFlowControl) {
        long streamHandle = JniLibrary.initStream(this.engineHandle);
        EnvoyHTTPStream stream = new EnvoyHTTPStream(this.engineHandle, streamHandle, callbacks, explicitFlowControl);
        stream.start();
        return stream;
    }

    @Override
    public EnvoyStatus runWithConfig(EnvoyConfiguration envoyConfiguration, String logLevel) {
        this.performRegistration(envoyConfiguration);
        int status = JniLibrary.runEngine(this.engineHandle, "", envoyConfiguration.createBootstrap(), logLevel);
        if (status == 0) {
            return EnvoyStatus.ENVOY_SUCCESS;
        }
        return EnvoyStatus.ENVOY_FAILURE;
    }

    private EnvoyStatus runWithResolvedYAML(String configurationYAML, String logLevel) {
        try {
            int status = JniLibrary.runEngine(this.engineHandle, configurationYAML, 0L, logLevel);
            if (status == 0) {
                return EnvoyStatus.ENVOY_SUCCESS;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return EnvoyStatus.ENVOY_FAILURE;
    }

    @Override
    public EnvoyStatus runWithYaml(String configurationYAML, String logLevel) {
        return this.runWithResolvedYAML(configurationYAML, logLevel);
    }

    @Override
    public String dumpStats() {
        return JniLibrary.dumpStats(this.engineHandle);
    }

    public EnvoyEngineImpl(EnvoyOnEngineRunning runningCallback, EnvoyLogger logger, EnvoyEventTracker eventTracker) {
        JniLibrary.load();
        this.engineHandle = JniLibrary.initEngine(runningCallback, logger, eventTracker);
    }

    @Override
    public void performRegistration(EnvoyConfiguration envoyConfiguration) {
        for (EnvoyHTTPFilterFactory envoyHTTPFilterFactory : envoyConfiguration.httpPlatformFilterFactories) {
            JniLibrary.registerFilterFactory(envoyHTTPFilterFactory.getFilterName(), new JvmFilterFactoryContext(envoyHTTPFilterFactory));
        }
        for (Map.Entry entry : envoyConfiguration.stringAccessors.entrySet()) {
            JniLibrary.registerStringAccessor((String)entry.getKey(), new JvmStringAccessorContext((EnvoyStringAccessor)entry.getValue()));
        }
        for (Map.Entry entry : envoyConfiguration.keyValueStores.entrySet()) {
            JniLibrary.registerKeyValueStore((String)entry.getKey(), new JvmKeyValueStoreContext((EnvoyKeyValueStore)entry.getValue()));
        }
    }

    @Override
    public void resetConnectivityState() {
        JniLibrary.resetConnectivityState(this.engineHandle);
    }

    @Override
    public void setLogLevel(EnvoyEngine.LogLevel log_level) {
        JniLibrary.setLogLevel(log_level.ordinal());
    }

    @Override
    public void setPreferredNetwork(EnvoyNetworkType network) {
        switch (network) {
            case ENVOY_NETWORK_TYPE_WWAN: {
                JniLibrary.setPreferredNetwork(this.engineHandle, 1);
                return;
            }
            case ENVOY_NETWORK_TYPE_WLAN: {
                JniLibrary.setPreferredNetwork(this.engineHandle, 2);
                return;
            }
            case ENVOY_NETWORK_TYPE_GENERIC: {
                JniLibrary.setPreferredNetwork(this.engineHandle, 0);
                return;
            }
        }
        JniLibrary.setPreferredNetwork(this.engineHandle, 0);
    }

    @Override
    public void setProxySettings(String host, int port) {
        JniLibrary.setProxySettings(this.engineHandle, host, port);
    }

    @Override
    public void terminate() {
        JniLibrary.terminateEngine(this.engineHandle);
    }
}

