/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.envoymobile.engine;

import io.envoyproxy.envoymobile.engine.JniBridgeUtility;
import io.envoyproxy.envoymobile.engine.JniLibrary;
import io.envoyproxy.envoymobile.engine.JvmCallbackContext;
import io.envoyproxy.envoymobile.engine.types.EnvoyHTTPCallbacks;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class EnvoyHTTPStream {
    private final long engineHandle;
    private final long streamHandle;
    private final boolean explicitFlowControl;
    private final JvmCallbackContext callbacksContext;

    public int cancel() {
        return JniLibrary.resetStream(this.engineHandle, this.streamHandle);
    }

    public EnvoyHTTPStream(long engineHandle, long streamHandle, EnvoyHTTPCallbacks callbacks, boolean explicitFlowControl) {
        this.engineHandle = engineHandle;
        this.streamHandle = streamHandle;
        this.explicitFlowControl = explicitFlowControl;
        this.callbacksContext = new JvmCallbackContext(callbacks);
    }

    public void readData(long byteCount) {
        if (!this.explicitFlowControl) {
            throw new UnsupportedOperationException("Called readData without explicit flow control.");
        }
        JniLibrary.readData(this.engineHandle, this.streamHandle, byteCount);
    }

    public void sendData(ByteBuffer data, boolean endStream) {
        this.sendData(data, data.capacity(), endStream);
    }

    public void sendData(ByteBuffer data, int length, boolean endStream) {
        if (length < 0 || length > data.capacity()) {
            throw new IllegalArgumentException("Length out of bound");
        }
        if (data.isDirect()) {
            JniLibrary.sendData(this.engineHandle, this.streamHandle, data, length, endStream);
        } else if (data.hasArray()) {
            JniLibrary.sendDataByteArray(this.engineHandle, this.streamHandle, data.array(), length, endStream);
        } else {
            throw new UnsupportedOperationException("Unsupported ByteBuffer implementation.");
        }
    }

    public void sendHeaders(Map<String, List<String>> headers, boolean endStream) {
        JniLibrary.sendHeaders(this.engineHandle, this.streamHandle, JniBridgeUtility.toJniHeaders(headers), endStream);
    }

    public void sendTrailers(Map<String, List<String>> trailers) {
        JniLibrary.sendTrailers(this.engineHandle, this.streamHandle, JniBridgeUtility.toJniHeaders(trailers));
    }

    void start() {
        JniLibrary.startStream(this.engineHandle, this.streamHandle, this.callbacksContext, this.explicitFlowControl);
    }
}

