/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.envoymobile.engine;

import io.envoyproxy.envoymobile.engine.EnvoyNativeResourceReleaser;
import io.envoyproxy.envoymobile.engine.EnvoyNativeResourceWrapper;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public enum EnvoyNativeResourceRegistry {
    SINGLETON;

    private ReferenceQueue<EnvoyNativeResourceWrapper> refQueue = new ReferenceQueue();
    private Set refMaintainer;
    private RefQueueThread refQueueThread = new RefQueueThread();

    private EnvoyNativeResourceRegistry() {
        new ConcurrentHashMap();
        this.refMaintainer = ConcurrentHashMap.newKeySet();
        this.refQueueThread.start();
    }

    public static void globalRegister(EnvoyNativeResourceWrapper owner, long nativeHandle, EnvoyNativeResourceReleaser releaser) {
        SINGLETON.register(owner, nativeHandle, releaser);
    }

    public void register(EnvoyNativeResourceWrapper owner, long nativeHandle, EnvoyNativeResourceReleaser releaser) {
        EnvoyPhantomRef ref = new EnvoyPhantomRef(owner, nativeHandle, releaser);
        this.refMaintainer.add(ref);
    }

    private class RefQueueThread
    extends Thread {
        private RefQueueThread() {
        }

        @Override
        public void run() {
            while (true) {
                EnvoyPhantomRef ref;
                try {
                    ref = (EnvoyPhantomRef)EnvoyNativeResourceRegistry.this.refQueue.remove();
                }
                catch (InterruptedException e) {
                    continue;
                }
                ref.releaseResource();
                EnvoyNativeResourceRegistry.this.refMaintainer.remove(ref);
            }
        }
    }

    private class EnvoyPhantomRef
    extends PhantomReference<EnvoyNativeResourceWrapper> {
        private final EnvoyNativeResourceReleaser releaser;
        private final long nativeHandle;

        EnvoyPhantomRef(EnvoyNativeResourceWrapper owner, long nativeHandle, EnvoyNativeResourceReleaser releaser) {
            super(owner, EnvoyNativeResourceRegistry.this.refQueue);
            this.nativeHandle = nativeHandle;
            this.releaser = releaser;
        }

        void releaseResource() {
            this.releaser.release(this.nativeHandle);
        }
    }
}

