/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.envoymobile.engine;

import io.envoyproxy.envoymobile.engine.EnvoyNativeFilterConfig;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class JniBridgeUtility {
    private JniBridgeUtility() {
    }

    public static byte[][] mapToJniBytes(Map<String, String> stringMap) {
        ArrayList<byte[]> convertedBytes = new ArrayList<byte[]>(stringMap.size() * 2);
        for (Map.Entry<String, String> entry : stringMap.entrySet()) {
            convertedBytes.add(entry.getKey().getBytes(StandardCharsets.UTF_8));
            convertedBytes.add(entry.getValue().getBytes(StandardCharsets.UTF_8));
        }
        return (byte[][])convertedBytes.toArray((T[])new byte[0][0]);
    }

    public static byte[][] stringsToJniBytes(List<String> stringList) {
        ArrayList<byte[]> convertedBytes = new ArrayList<byte[]>(stringList.size());
        for (String str : stringList) {
            convertedBytes.add(str.getBytes(StandardCharsets.UTF_8));
        }
        return (byte[][])convertedBytes.toArray((T[])new byte[0][0]);
    }

    public static byte[][] toJniBytes(List<EnvoyNativeFilterConfig> nativeFilterChain) {
        ArrayList<byte[]> convertedBytes = new ArrayList<byte[]>(nativeFilterChain.size());
        for (EnvoyNativeFilterConfig filter : nativeFilterChain) {
            convertedBytes.add(filter.name.getBytes(StandardCharsets.UTF_8));
            convertedBytes.add(filter.typedConfig.getBytes(StandardCharsets.UTF_8));
        }
        return (byte[][])convertedBytes.toArray((T[])new byte[0][0]);
    }

    public static byte[][] toJniHeaders(Map<String, List<String>> headers) {
        if (headers == null) {
            return null;
        }
        ArrayList<byte[]> convertedHeaders = new ArrayList<byte[]>(2 * headers.size());
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            for (String value : entry.getValue()) {
                convertedHeaders.add(entry.getKey().getBytes(StandardCharsets.UTF_8));
                convertedHeaders.add(value.getBytes(StandardCharsets.UTF_8));
            }
        }
        return (byte[][])convertedHeaders.toArray((T[])new byte[0][0]);
    }

    public static byte[][] toJniTags(Map<String, String> tags) {
        if (tags == null) {
            return null;
        }
        ArrayList<byte[]> convertedTags = new ArrayList<byte[]>(2 * tags.size());
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            convertedTags.add(tag.getKey().getBytes(StandardCharsets.UTF_8));
            convertedTags.add(tag.getValue().getBytes(StandardCharsets.UTF_8));
        }
        return (byte[][])convertedTags.toArray((T[])new byte[0][0]);
    }
}

