/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.envoymobile.engine;

import io.envoyproxy.envoymobile.engine.EnvoyFinalStreamIntelImpl;
import io.envoyproxy.envoymobile.engine.EnvoyStreamIntelImpl;
import io.envoyproxy.envoymobile.engine.JvmBridgeUtility;
import io.envoyproxy.envoymobile.engine.types.EnvoyHTTPCallbacks;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

class JvmCallbackContext {
    private final JvmBridgeUtility bridgeUtility = new JvmBridgeUtility();
    private final EnvoyHTTPCallbacks callbacks;

    public Object onCancel(final long[] streamIntel, final long[] finalStreamIntel) {
        this.callbacks.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                JvmCallbackContext.this.callbacks.onCancel(new EnvoyStreamIntelImpl(streamIntel), new EnvoyFinalStreamIntelImpl(finalStreamIntel));
            }
        });
        return null;
    }

    public Object onComplete(final long[] streamIntel, final long[] finalStreamIntel) {
        this.callbacks.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                JvmCallbackContext.this.callbacks.onComplete(new EnvoyStreamIntelImpl(streamIntel), new EnvoyFinalStreamIntelImpl(finalStreamIntel));
            }
        });
        return null;
    }

    public Object onError(final int errorCode, final byte[] message, final int attemptCount, final long[] streamIntel, final long[] finalStreamIntel) {
        this.callbacks.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                String errorMessage = new String(message);
                JvmCallbackContext.this.callbacks.onError(errorCode, errorMessage, attemptCount, new EnvoyStreamIntelImpl(streamIntel), new EnvoyFinalStreamIntelImpl(finalStreamIntel));
            }
        });
        return null;
    }

    public Object onResponseData(final byte[] data, final boolean endStream, final long[] streamIntel) {
        this.callbacks.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                ByteBuffer dataBuffer = ByteBuffer.wrap(data);
                JvmCallbackContext.this.callbacks.onData(dataBuffer, endStream, new EnvoyStreamIntelImpl(streamIntel));
            }
        });
        return null;
    }

    public Object onResponseHeaders(long headerCount, final boolean endStream, final long[] streamIntel) {
        assert (this.bridgeUtility.validateCount(headerCount));
        final Map<String, List<String>> headers = this.bridgeUtility.retrieveHeaders();
        this.callbacks.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                JvmCallbackContext.this.callbacks.onHeaders(headers, endStream, new EnvoyStreamIntelImpl(streamIntel));
            }
        });
        return null;
    }

    public Object onResponseTrailers(long trailerCount, final long[] streamIntel) {
        assert (this.bridgeUtility.validateCount(trailerCount));
        final Map<String, List<String>> trailers = this.bridgeUtility.retrieveHeaders();
        this.callbacks.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                JvmCallbackContext.this.callbacks.onTrailers(trailers, new EnvoyStreamIntelImpl(streamIntel));
            }
        });
        return null;
    }

    public Object onSendWindowAvailable(final long[] streamIntel) {
        this.callbacks.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                JvmCallbackContext.this.callbacks.onSendWindowAvailable(new EnvoyStreamIntelImpl(streamIntel));
            }
        });
        return null;
    }

    public JvmCallbackContext(EnvoyHTTPCallbacks callbacks) {
        this.callbacks = callbacks;
    }

    void passHeader(byte[] key, byte[] value, boolean start) {
        this.bridgeUtility.passHeader(key, value, start);
    }
}

