/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.envoymobile.engine;

import io.envoyproxy.envoymobile.engine.EnvoyFinalStreamIntelImpl;
import io.envoyproxy.envoymobile.engine.EnvoyHTTPFilterCallbacksImpl;
import io.envoyproxy.envoymobile.engine.EnvoyStreamIntelImpl;
import io.envoyproxy.envoymobile.engine.JniBridgeUtility;
import io.envoyproxy.envoymobile.engine.JvmBridgeUtility;
import io.envoyproxy.envoymobile.engine.types.EnvoyHTTPFilter;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

class JvmFilterContext {
    private final JvmBridgeUtility headerUtility = new JvmBridgeUtility();
    private final JvmBridgeUtility trailerUtility = new JvmBridgeUtility();
    private final EnvoyHTTPFilter filter;

    public Object onCancel(long[] streamIntel, long[] finalStreamIntel) {
        this.filter.onCancel(new EnvoyStreamIntelImpl(streamIntel), new EnvoyFinalStreamIntelImpl(finalStreamIntel));
        return null;
    }

    public Object onComplete(long[] streamIntel, long[] finalStreamIntel) {
        this.filter.onComplete(new EnvoyStreamIntelImpl(streamIntel), new EnvoyFinalStreamIntelImpl(finalStreamIntel));
        return null;
    }

    public Object onError(int errorCode, byte[] message, int attemptCount, long[] streamIntel, long[] finalStreamIntel) {
        String errorMessage = new String(message);
        this.filter.onError(errorCode, errorMessage, attemptCount, new EnvoyStreamIntelImpl(streamIntel), new EnvoyFinalStreamIntelImpl(finalStreamIntel));
        return null;
    }

    public Object onRequestData(byte[] data, boolean endStream, long[] streamIntel) {
        ByteBuffer dataBuffer = ByteBuffer.wrap(data);
        return JvmFilterContext.toJniFilterDataStatus(this.filter.onRequestData(dataBuffer, endStream, new EnvoyStreamIntelImpl(streamIntel)));
    }

    public Object onRequestHeaders(long headerCount, boolean endStream, long[] streamIntel) {
        assert (this.headerUtility.validateCount(headerCount));
        Map<String, List<String>> headers = this.headerUtility.retrieveHeaders();
        return JvmFilterContext.toJniFilterHeadersStatus(this.filter.onRequestHeaders(headers, endStream, new EnvoyStreamIntelImpl(streamIntel)));
    }

    public Object onRequestTrailers(long trailerCount, long[] streamIntel) {
        assert (this.headerUtility.validateCount(trailerCount));
        Map<String, List<String>> trailers = this.headerUtility.retrieveHeaders();
        return JvmFilterContext.toJniFilterTrailersStatus(this.filter.onRequestTrailers(trailers, new EnvoyStreamIntelImpl(streamIntel)));
    }

    public Object onResponseData(byte[] data, boolean endStream, long[] streamIntel) {
        ByteBuffer dataBuffer = ByteBuffer.wrap(data);
        return JvmFilterContext.toJniFilterDataStatus(this.filter.onResponseData(dataBuffer, endStream, new EnvoyStreamIntelImpl(streamIntel)));
    }

    public Object onResponseHeaders(long headerCount, boolean endStream, long[] streamIntel) {
        assert (this.headerUtility.validateCount(headerCount));
        Map<String, List<String>> headers = this.headerUtility.retrieveHeaders();
        return JvmFilterContext.toJniFilterHeadersStatus(this.filter.onResponseHeaders(headers, endStream, new EnvoyStreamIntelImpl(streamIntel)));
    }

    public Object onResponseTrailers(long trailerCount, long[] streamIntel) {
        assert (this.headerUtility.validateCount(trailerCount));
        Map<String, List<String>> trailers = this.headerUtility.retrieveHeaders();
        return JvmFilterContext.toJniFilterTrailersStatus(this.filter.onResponseTrailers(trailers, new EnvoyStreamIntelImpl(streamIntel)));
    }

    public Object onResumeRequest(long headerCount, byte[] data, long trailerCount, boolean endStream, long[] streamIntel) {
        Map<String, List<String>> headers = null;
        if (headerCount >= 0L) {
            assert (this.headerUtility.validateCount(headerCount));
            headers = this.headerUtility.retrieveHeaders();
        }
        ByteBuffer dataBuffer = data == null ? null : ByteBuffer.wrap(data);
        Map<String, List<String>> trailers = null;
        if (trailerCount >= 0L) {
            assert (this.trailerUtility.validateCount(trailerCount));
            trailers = this.trailerUtility.retrieveHeaders();
        }
        return JvmFilterContext.toJniFilterResumeStatus(this.filter.onResumeRequest(headers, dataBuffer, trailers, endStream, new EnvoyStreamIntelImpl(streamIntel)));
    }

    public Object onResumeResponse(long headerCount, byte[] data, long trailerCount, boolean endStream, long[] streamIntel) {
        Map<String, List<String>> headers = null;
        if (headerCount >= 0L) {
            assert (this.headerUtility.validateCount(headerCount));
            headers = this.headerUtility.retrieveHeaders();
        }
        ByteBuffer dataBuffer = data == null ? null : ByteBuffer.wrap(data);
        Map<String, List<String>> trailers = null;
        if (trailerCount >= 0L) {
            assert (this.trailerUtility.validateCount(trailerCount));
            trailers = this.trailerUtility.retrieveHeaders();
        }
        return JvmFilterContext.toJniFilterResumeStatus(this.filter.onResumeResponse(headers, dataBuffer, trailers, endStream, new EnvoyStreamIntelImpl(streamIntel)));
    }

    public JvmFilterContext(EnvoyHTTPFilter filter) {
        this.filter = filter;
    }

    public void passHeader(byte[] key, byte[] value, boolean start) {
        this.headerUtility.passHeader(key, value, start);
    }

    public void passTrailer(byte[] key, byte[] value, boolean start) {
        this.trailerUtility.passHeader(key, value, start);
    }

    public void setRequestFilterCallbacks(long callbackHandle) {
        this.filter.setRequestFilterCallbacks(EnvoyHTTPFilterCallbacksImpl.create(callbackHandle));
    }

    public void setResponseFilterCallbacks(long callbackHandle) {
        this.filter.setResponseFilterCallbacks(EnvoyHTTPFilterCallbacksImpl.create(callbackHandle));
    }

    private static Object[] toJniFilterDataStatus(Object[] result) {
        if (result.length == 3) {
            result[2] = JvmFilterContext.toJniHeaders(result[2]);
            return result;
        }
        assert (result.length == 2);
        return result;
    }

    private static Object[] toJniFilterHeadersStatus(Object[] result) {
        assert (result.length == 2);
        result[1] = JvmFilterContext.toJniHeaders(result[1]);
        return result;
    }

    private static Object[] toJniFilterResumeStatus(Object[] result) {
        assert (result.length == 4);
        result[1] = JvmFilterContext.toJniHeaders(result[1]);
        result[3] = JvmFilterContext.toJniHeaders(result[3]);
        return result;
    }

    private static Object[] toJniFilterTrailersStatus(Object[] result) {
        result[1] = JvmFilterContext.toJniHeaders(result[1]);
        if (result.length == 4) {
            result[2] = JvmFilterContext.toJniHeaders(result[2]);
            return result;
        }
        assert (result.length == 2);
        return result;
    }

    private static byte[][] toJniHeaders(Object headers) {
        return JniBridgeUtility.toJniHeaders((Map)headers);
    }
}

