/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.envoymobile.engine;

import io.envoyproxy.envoymobile.engine.types.EnvoyKeyValueStore;
import java.nio.charset.StandardCharsets;

class JvmKeyValueStoreContext {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final EnvoyKeyValueStore keyValueStore;

    public JvmKeyValueStoreContext(EnvoyKeyValueStore keyValueStore) {
        this.keyValueStore = keyValueStore;
    }

    public void remove(byte[] key) {
        this.keyValueStore.remove(new String(key, StandardCharsets.UTF_8));
    }

    public void save(byte[] key, byte[] value) {
        this.keyValueStore.save(new String(key, StandardCharsets.UTF_8), new String(value, StandardCharsets.UTF_8));
    }

    public byte[] read(byte[] key) {
        String value = this.keyValueStore.read(new String(key, StandardCharsets.UTF_8));
        if (value == null) {
            return EMPTY_BYTES;
        }
        return value.getBytes(StandardCharsets.UTF_8);
    }
}

