/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.envoymobile.utilities;

import android.net.TrafficStats;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.security.NetworkSecurityPolicy;
import io.envoyproxy.envoymobile.utilities.AndroidCertVerifyResult;
import io.envoyproxy.envoymobile.utilities.FakeX509Util;
import io.envoyproxy.envoymobile.utilities.ThreadStatsUid;
import io.envoyproxy.envoymobile.utilities.X509Util;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketImpl;
import java.nio.charset.StandardCharsets;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public final class AndroidNetworkLibrary {
    private static final String TAG = "AndroidNetworkLibrary";
    private static boolean mUseFakeCertificateVerification;

    public static synchronized AndroidCertVerifyResult verifyServerCertificates(byte[][] certChain, byte[] authTypeBytes, byte[] hostBytes) {
        String authType = new String(authTypeBytes, StandardCharsets.UTF_8);
        String host = new String(hostBytes, StandardCharsets.UTF_8);
        if (mUseFakeCertificateVerification) {
            AndroidCertVerifyResult result = FakeX509Util.verifyServerCertificates(certChain, authType, host);
            return result;
        }
        try {
            return X509Util.verifyServerCertificates(certChain, authType, host);
        }
        catch (KeyStoreException e) {
            return new AndroidCertVerifyResult(-1);
        }
        catch (NoSuchAlgorithmException e) {
            return new AndroidCertVerifyResult(-1);
        }
        catch (IllegalArgumentException e) {
            return new AndroidCertVerifyResult(-1);
        }
    }

    public static void addTestRootCertificate(byte[] rootCert) throws CertificateException, KeyStoreException, NoSuchAlgorithmException {
        if (mUseFakeCertificateVerification) {
            FakeX509Util.addTestRootCertificate(rootCert);
        } else {
            X509Util.addTestRootCertificate(rootCert);
        }
    }

    public static void clearTestRootCertificates() throws NoSuchAlgorithmException, CertificateException, KeyStoreException {
        if (mUseFakeCertificateVerification) {
            FakeX509Util.clearTestRootCertificates();
        } else {
            X509Util.clearTestRootCertificates();
        }
    }

    public static synchronized void setFakeCertificateVerificationForTesting(boolean useFakeCertificateVerification) {
        mUseFakeCertificateVerification = useFakeCertificateVerification;
    }

    private static void tagSocket(int ifd, int uid, int tag) throws IOException {
        FileDescriptor fd;
        ParcelFileDescriptor pfd;
        int oldTag = TrafficStats.getThreadStatsTag();
        if (tag != oldTag) {
            TrafficStats.setThreadStatsTag((int)tag);
        }
        if (uid != -1) {
            ThreadStatsUid.set(uid);
        }
        if (Build.VERSION.SDK_INT < 23) {
            pfd = null;
            fd = SetFileDescriptor.createWithFd(ifd);
        } else {
            pfd = ParcelFileDescriptor.adoptFd((int)ifd);
            fd = pfd.getFileDescriptor();
        }
        SocketFd s = new SocketFd(fd);
        TrafficStats.tagSocket((Socket)s);
        s.close();
        if (pfd != null) {
            pfd.detachFd();
        }
        if (tag != oldTag) {
            TrafficStats.setThreadStatsTag((int)oldTag);
        }
        if (uid != -1) {
            ThreadStatsUid.clear();
        }
    }

    public static synchronized boolean getFakeCertificateVerificationForTesting() {
        return mUseFakeCertificateVerification;
    }

    public static boolean isCleartextTrafficPermitted(String host) {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        if (Build.VERSION.SDK_INT == 23) {
            return NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted();
        }
        return NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted(host);
    }

    private static class SetFileDescriptor {
        private static final Method sFileDescriptorSetInt;

        public static FileDescriptor createWithFd(int fd) {
            try {
                FileDescriptor fileDescriptor = new FileDescriptor();
                sFileDescriptorSetInt.invoke((Object)fileDescriptor, fd);
                return fileDescriptor;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("FileDescriptor.setInt$() failed", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("FileDescriptor.setInt$() failed", e);
            }
        }

        static {
            try {
                sFileDescriptorSetInt = FileDescriptor.class.getMethod("setInt$", Integer.TYPE);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new RuntimeException("Unable to get FileDescriptor.setInt$", e);
            }
        }

        private SetFileDescriptor() {
        }
    }

    private static class SocketFd
    extends Socket {
        SocketFd(FileDescriptor fd) throws IOException {
            super(new SocketImplFd(fd));
        }

        private static class SocketImplFd
        extends SocketImpl {
            @Override
            protected int available() {
                throw new RuntimeException("accept not implemented");
            }

            @Override
            protected InputStream getInputStream() {
                throw new RuntimeException("getInputStream not implemented");
            }

            @Override
            protected OutputStream getOutputStream() {
                throw new RuntimeException("getOutputStream not implemented");
            }

            @Override
            public Object getOption(int optID) {
                throw new RuntimeException("getOption not implemented");
            }

            SocketImplFd(FileDescriptor fd) {
                this.fd = fd;
            }

            @Override
            protected void accept(SocketImpl s) {
                throw new RuntimeException("accept not implemented");
            }

            @Override
            protected void bind(InetAddress host, int port) {
                throw new RuntimeException("accept not implemented");
            }

            @Override
            protected void close() {
            }

            @Override
            protected void connect(String host, int port) {
                throw new RuntimeException("connect not implemented");
            }

            @Override
            protected void connect(InetAddress address, int port) {
                throw new RuntimeException("connect not implemented");
            }

            @Override
            protected void connect(SocketAddress address, int timeout) {
                throw new RuntimeException("connect not implemented");
            }

            @Override
            protected void create(boolean stream) {
            }

            @Override
            protected void listen(int backlog) {
                throw new RuntimeException("listen not implemented");
            }

            @Override
            protected void sendUrgentData(int data) {
                throw new RuntimeException("sendUrgentData not implemented");
            }

            @Override
            public void setOption(int optID, Object value) {
                throw new RuntimeException("setOption not implemented");
            }
        }
    }
}

