/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.envoymobile.utilities;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Handler;
import android.preference.PreferenceManager;
import androidx.annotation.VisibleForTesting;
import io.envoyproxy.envoymobile.utilities.ContextUtils$$ExternalSyntheticBackport0;
import io.envoyproxy.envoymobile.utilities.StrictModeContext;

public final class ContextUtils {
    private static final String TAG = "ContextUtils";
    private static Context sApplicationContext;
    private static boolean sSdkSandboxProcess;
    public static final int RECEIVER_EXPORTED = 2;
    public static final int RECEIVER_NOT_EXPORTED = 4;

    public static Context getApplicationContext() {
        return sApplicationContext;
    }

    private static Intent registerBroadcastReceiver(Context context, BroadcastReceiver receiver, IntentFilter filter, String permission2, Handler scheduler, int flags) {
        if (Build.VERSION.SDK_INT >= 26) {
            return context.registerReceiver(receiver, filter, permission2, scheduler, flags);
        }
        return context.registerReceiver(receiver, filter, permission2, scheduler);
    }

    public static Intent registerExportedBroadcastReceiver(Context context, BroadcastReceiver receiver, IntentFilter filter, String permission2) {
        return ContextUtils.registerBroadcastReceiver(context, receiver, filter, permission2, null, 2);
    }

    public static Intent registerNonExportedBroadcastReceiver(Context context, BroadcastReceiver receiver, IntentFilter filter) {
        return ContextUtils.registerBroadcastReceiver(context, receiver, filter, null, null, 4);
    }

    public static Intent registerNonExportedBroadcastReceiver(Context context, BroadcastReceiver receiver, IntentFilter filter, Handler scheduler) {
        return ContextUtils.registerBroadcastReceiver(context, receiver, filter, null, scheduler, 4);
    }

    static /* synthetic */ SharedPreferences access$000() {
        return ContextUtils.fetchAppSharedPreferences();
    }

    private static SharedPreferences fetchAppSharedPreferences() {
        StrictModeContext ignored = StrictModeContext.allowDiskWrites();
        try {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)sApplicationContext);
            if (ignored != null) {
                ignored.close();
            }
            return sharedPreferences;
        }
        catch (Throwable throwable) {
            if (ignored != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    ContextUtils$$ExternalSyntheticBackport0.m(throwable, throwable2);
                }
            }
            throw throwable;
        }
    }

    public static SharedPreferences getAppSharedPreferences() {
        return Holder.sSharedPreferences;
    }

    @VisibleForTesting
    public static void clearApplicationContextForTests() {
        sApplicationContext = null;
        Holder.sSharedPreferences = null;
    }

    public static void initApplicationContext(Context appContext) {
        assert (sApplicationContext == null || sApplicationContext == appContext || ((ContextWrapper)sApplicationContext).getBaseContext() == appContext);
        ContextUtils.initJavaSideApplicationContext(appContext);
    }

    @VisibleForTesting
    public static void initApplicationContextForTests(Context appContext) {
        ContextUtils.initJavaSideApplicationContext(appContext);
        Holder.sSharedPreferences = ContextUtils.fetchAppSharedPreferences();
    }

    private static void initJavaSideApplicationContext(Context appContext) {
        assert (appContext != null);
        if (appContext instanceof Application) {
            appContext = new ContextWrapper(appContext);
        }
        sApplicationContext = appContext;
    }

    private static class Holder {
        private static SharedPreferences sSharedPreferences = ContextUtils.access$000();

        private Holder() {
        }
    }
}

