/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.envoymobile.utilities;

import io.envoyproxy.envoymobile.utilities.AndroidCertVerifyResult;
import io.envoyproxy.envoymobile.utilities.ContextUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class FakeX509Util {
    private static final Set<String> validFakeCerts = new HashSet<String>();
    public static final String expectedAuthType = "RSA";
    private static String expectedHost = "www.example.com";

    public static AndroidCertVerifyResult verifyServerCertificates(byte[][] certChain, String authType, String host) {
        if (certChain == null || certChain.length == 0 || certChain[0] == null) {
            throw new IllegalArgumentException("Expected non-null and non-empty certificate chain passed as |certChain|. |certChain|=" + Arrays.deepToString((Object[])certChain));
        }
        if (ContextUtils.getApplicationContext() == null) {
            throw new NullPointerException("ContextUtils is not initialized with a proper context. Call initApplicationContext() during startup.");
        }
        for (byte[] cert : certChain) {
            String fakeCert = new String(cert);
            if (validFakeCerts.contains(fakeCert)) continue;
            return new AndroidCertVerifyResult(-2);
        }
        return authType.equals(expectedAuthType) && host.equals(expectedHost) ? new AndroidCertVerifyResult(0) : new AndroidCertVerifyResult(-1);
    }

    public static String getExpectedHost() {
        return expectedHost;
    }

    public static void addTestRootCertificate(byte[] rootCertBytes) {
        String fakeCertificate = new String(rootCertBytes);
        validFakeCerts.add(fakeCertificate);
    }

    public static void clearTestRootCertificates() {
        validFakeCerts.clear();
    }

    public static void setExpectedHost(String host) {
        expectedHost = host;
    }
}

