/*
 * Decompiled with CFR 0.152.
 */
package io.es4j.test;

import io.es4j.Aggregate;
import io.es4j.Es4jDeployment;
import io.es4j.client.AggregateHttpClient;
import io.es4j.core.CommandHandler;
import io.es4j.infrastructure.AggregateCache;
import io.es4j.infrastructure.EventStore;
import io.es4j.infrastructure.OffsetStore;
import io.es4j.infrastructure.cache.CaffeineAggregateCache;
import io.es4j.infrastructure.misc.Es4jServiceLoader;
import io.es4j.infrastructure.proxy.AggregateEventBusPoxy;
import io.es4j.launcher.Es4jMain;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.WebClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class Es4jBootstrapper<T extends Aggregate> {
    private final String infraConfig;
    public AggregateEventBusPoxy<T> eventBusPoxy;
    public AggregateHttpClient<T> httpClient;
    private static Network network = Network.newNetwork();
    public static final String POSTGRES_VERSION = "postgres:latest";
    public static final String ZOOKEEPER_VERSION = "bitnami/zookeeper:latest";
    private final Logger LOGGER = LoggerFactory.getLogger(Es4jBootstrapper.class);
    public PostgreSQLContainer<?> postgreSQLContainer;
    public GenericContainer redis;
    public static Vertx vertx;
    public JsonObject config;
    public Boolean postgres = Boolean.parseBoolean(System.getenv().getOrDefault("POSTGRES", "false"));
    public Boolean clustered = Boolean.parseBoolean(System.getenv().getOrDefault("CLUSTERED", "false"));
    public String HTTP_HOST = System.getenv().getOrDefault("HTTP_HOST", "localhost");
    public Integer HTTP_PORT = Integer.parseInt(System.getenv().getOrDefault("HTTP_PORT", "8080"));
    public Class<T> aggregateClass;
    private GenericContainer zookeeperContainer;
    public AggregateCache cache;
    public EventStore eventStore;
    public OffsetStore offsetStore;

    public Es4jBootstrapper(Class<T> aggregateClass, String infraConfig) {
        vertx = Vertx.vertx();
        this.infraConfig = infraConfig;
        this.aggregateClass = aggregateClass;
    }

    public void bootstrap() {
        Es4jDeployment deployment = new Es4jDeployment(){

            public Class<? extends Aggregate> aggregateClass() {
                return Es4jBootstrapper.this.aggregateClass;
            }
        };
        this.config = this.configuration().put("schema", (Object)CommandHandler.camelToKebab((String)this.aggregateClass.getSimpleName()));
        if (Boolean.TRUE.equals(this.infrastructure())) {
            this.eventStore = Es4jServiceLoader.loadEventStore();
            this.deployPgContainer();
            vertx.deployVerticle(Es4jMain::new, new DeploymentOptions().setInstances(1).setConfig(this.config)).await().indefinitely();
            this.cache = new CaffeineAggregateCache();
            this.eventStore.start(deployment, vertx, this.config);
            this.offsetStore = Es4jServiceLoader.loadOffsetStore();
            this.offsetStore.start(deployment, vertx, this.config);
        }
        this.httpClient = new AggregateHttpClient(WebClient.create((Vertx)vertx, (WebClientOptions)new WebClientOptions().setDefaultHost(this.HTTP_HOST).setDefaultPort(this.HTTP_PORT.intValue())), this.aggregateClass);
        this.eventBusPoxy = new AggregateEventBusPoxy(vertx, this.aggregateClass);
    }

    public Es4jBootstrapper<T> setRemoteHost(String host) {
        this.HTTP_HOST = host;
        return this;
    }

    public Es4jBootstrapper<T> setRemotePort(Integer port) {
        this.HTTP_PORT = port;
        return this;
    }

    public Es4jBootstrapper<T> setPostgres(Boolean postgres) {
        this.postgres = postgres;
        return this;
    }

    public Boolean infrastructure() {
        return this.postgres;
    }

    public JsonObject configuration() {
        return vertx.fileSystem().readFileBlocking(this.infraConfig + ".json").toJsonObject();
    }

    private void deployRedisContainer() {
        this.redis = new GenericContainer(DockerImageName.parse((String)"redis:latest")).withExposedPorts(new Integer[]{6379}).waitingFor((WaitStrategy)Wait.forListeningPort()).withNetwork(network);
        this.redis.start();
        this.config.put("redisHost", (Object)this.redis.getHost());
        this.config.put("redisPort", (Object)this.redis.getFirstMappedPort());
        vertx.fileSystem().writeFileBlocking(this.infraConfig + ".json", Buffer.newInstance((io.vertx.core.buffer.Buffer)this.config.toBuffer()));
        this.LOGGER.debug("Configuration after container bootstrap {}", (Object)this.config);
    }

    public void deployPgContainer() {
        this.postgreSQLContainer = (PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer(POSTGRES_VERSION).withNetwork(network)).waitingFor((WaitStrategy)Wait.forListeningPort());
        this.postgreSQLContainer.start();
        this.config.put("pgHost", (Object)this.postgreSQLContainer.getHost()).put("pgPort", (Object)this.postgreSQLContainer.getFirstMappedPort()).put("pgUser", (Object)this.postgreSQLContainer.getUsername()).put("pgPassword", (Object)this.postgreSQLContainer.getPassword()).put("pgDatabase", (Object)this.postgreSQLContainer.getDatabaseName()).put("jdbcUrl", (Object)this.postgreSQLContainer.getJdbcUrl());
        vertx.fileSystem().writeFileBlocking(this.infraConfig + ".json", Buffer.newInstance((io.vertx.core.buffer.Buffer)this.config.toBuffer()));
        this.LOGGER.debug("Configuration after container bootstrap {}", (Object)this.config);
    }

    public void deployZookeeper() {
        this.zookeeperContainer = new GenericContainer(DockerImageName.parse((String)ZOOKEEPER_VERSION)).withNetwork(network).waitingFor((WaitStrategy)Wait.forListeningPort());
        this.zookeeperContainer.start();
    }

    public void destroy() {
        vertx.closeAndAwait();
        if (Boolean.TRUE.equals(this.infrastructure())) {
            this.LOGGER.info(this.postgreSQLContainer.getLogs());
            this.postgreSQLContainer.stop();
            this.postgreSQLContainer.close();
        }
    }
}

