/*
 * Decompiled with CFR 0.152.
 */
package io.es4j.test;

import io.es4j.Aggregate;
import io.es4j.client.AggregateHttpClient;
import io.es4j.config.DatabaseConfiguration;
import io.es4j.config.DatabaseConfigurationCache;
import io.es4j.config.DatabaseConfigurationService;
import io.es4j.config.orm.ConfigurationKey;
import io.es4j.core.objects.AggregateState;
import io.es4j.infrastructure.AggregateCache;
import io.es4j.infrastructure.EventStore;
import io.es4j.infrastructure.OffsetStore;
import io.es4j.infrastructure.cache.CaffeineWrapper;
import io.es4j.infrastructure.config.FileConfigurationCache;
import io.es4j.infrastructure.models.AggregatePlainKey;
import io.es4j.infrastructure.proxy.AggregateEventBusPoxy;
import io.es4j.test.DatabaseBusinessRule;
import io.es4j.test.Es4jBootstrapper;
import io.es4j.test.Es4jTest;
import io.es4j.test.FileBusinessRule;
import io.es4j.test.GivenAggregate;
import io.smallrye.mutiny.tuples.Tuple4;
import io.vertx.core.json.JsonObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Es4jExtension
implements BeforeAllCallback,
AfterAllCallback,
Extension,
ParameterResolver,
BeforeEachCallback,
AfterEachCallback {
    private Es4jBootstrapper<? extends Aggregate> es4jBootstrapper;
    private final Logger LOGGER = LoggerFactory.getLogger(Es4jExtension.class);

    public void beforeAll(ExtensionContext extensionContext) {
        extensionContext.getTestClass().ifPresent(testClass -> {
            Es4jTest annotation = testClass.getAnnotation(Es4jTest.class);
            this.es4jBootstrapper = new Es4jBootstrapper<Aggregate>(annotation.aggregate(), annotation.infraConfig()).setPostgres(annotation.infrastructure()).setRemoteHost(annotation.host()).setRemotePort(annotation.port());
            this.es4jBootstrapper.bootstrap();
        });
    }

    public void afterAll(ExtensionContext extensionContext) {
        if (this.es4jBootstrapper != null) {
            this.es4jBootstrapper.destroy();
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == AggregateEventBusPoxy.class || parameterContext.getParameter().getType() == AggregateHttpClient.class || parameterContext.getParameter().getType() == EventStore.class || parameterContext.getParameter().getType() == OffsetStore.class || parameterContext.getParameter().getType() == AggregateCache.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (this.es4jBootstrapper != null) {
            if (parameterContext.getParameter().getType().isAssignableFrom(AggregateEventBusPoxy.class)) {
                return this.es4jBootstrapper.eventBusPoxy;
            }
            if (parameterContext.getParameter().getType().isAssignableFrom(AggregateHttpClient.class)) {
                return this.es4jBootstrapper.httpClient;
            }
            if (parameterContext.getParameter().getType().isAssignableFrom(EventStore.class)) {
                return this.es4jBootstrapper.eventStore;
            }
            if (parameterContext.getParameter().getType().isAssignableFrom(OffsetStore.class)) {
                return this.es4jBootstrapper.offsetStore;
            }
            if (parameterContext.getParameter().getType().isAssignableFrom(AggregateCache.class)) {
                return this.es4jBootstrapper.cache;
            }
        }
        throw new IllegalStateException("Bootstrapper has not been initialized");
    }

    private List<Tuple4<Class<? extends DatabaseConfiguration>, String, String, Integer>> databaseConfigurations(Method testMethod) {
        this.LOGGER.debug("Getting business rules from method {}", (Object)testMethod);
        ArrayList<Tuple4<Class<? extends DatabaseConfiguration>, String, String, Integer>> configurationTuples = new ArrayList<Tuple4<Class<? extends DatabaseConfiguration>, String, String, Integer>>();
        DatabaseBusinessRule[] annotations = (DatabaseBusinessRule[])testMethod.getAnnotationsByType(DatabaseBusinessRule.class);
        if (annotations != null && !Arrays.stream(annotations).toList().isEmpty()) {
            Arrays.stream(annotations).forEach(a -> configurationTuples.add(Tuple4.of(a.configurationClass(), (Object)a.fileName(), (Object)a.tenant(), (Object)a.version())));
            return configurationTuples;
        }
        return new ArrayList<Tuple4<Class<? extends DatabaseConfiguration>, String, String, Integer>>();
    }

    private List<String> fileConfigurations(Method testMethod) {
        this.LOGGER.debug("Getting business rules from method {}", (Object)testMethod);
        ArrayList<String> configurationTuples = new ArrayList<String>();
        FileBusinessRule[] annotations = (FileBusinessRule[])testMethod.getAnnotationsByType(FileBusinessRule.class);
        if (annotations != null && !Arrays.stream(annotations).toList().isEmpty()) {
            Arrays.stream(annotations).forEach(a -> configurationTuples.add(a.fileName()));
            return configurationTuples;
        }
        return new ArrayList<String>();
    }

    public void afterEach(ExtensionContext context) {
        context.getTestMethod().ifPresent(testMethod -> {
            List<String> fileConfigurations;
            List<Tuple4<Class<? extends DatabaseConfiguration>, String, String, Integer>> databaseConfigurations = this.databaseConfigurations((Method)testMethod);
            if (!databaseConfigurations.isEmpty()) {
                this.LOGGER.info("Removing previously deployed database configurations {}", databaseConfigurations);
                databaseConfigurations.forEach(dbConfig -> {
                    this.LOGGER.info("Deleting database configuration {}", dbConfig);
                    DatabaseConfigurationCache.invalidate((String)DatabaseConfigurationService.parseKey((ConfigurationKey)new ConfigurationKey(((Class)dbConfig.getItem1()).getName(), (Integer)dbConfig.getItem4(), (String)dbConfig.getItem3())));
                });
            }
            if (!(fileConfigurations = this.fileConfigurations((Method)testMethod)).isEmpty()) {
                this.LOGGER.info("Removing previously deployed configurations {}", databaseConfigurations);
                fileConfigurations.forEach(filename -> {
                    this.LOGGER.info("Deleting file configuration {}", filename);
                    FileConfigurationCache.invalidate((String)filename.substring(0, filename.indexOf(".")));
                });
            }
            Optional<GivenAggregate> optionalGivenAggregate = Optional.ofNullable(testMethod.getAnnotation(GivenAggregate.class));
            optionalGivenAggregate.ifPresent(this::dropAggregate);
        });
    }

    private void dropAggregate(GivenAggregate givenAggregate) {
        JsonObject jsonObject = Es4jBootstrapper.vertx.fileSystem().readFileBlocking(givenAggregate.filename()).toJsonObject();
        AggregateState state = this.getState(this.es4jBootstrapper.aggregateClass, jsonObject);
        CaffeineWrapper.invalidate(this.es4jBootstrapper.aggregateClass, (AggregatePlainKey)new AggregatePlainKey(this.es4jBootstrapper.aggregateClass.getName(), state.state().aggregateId(), state.state().tenant()));
    }

    private void addAggregate(GivenAggregate givenAggregate) {
        JsonObject jsonObject = Es4jBootstrapper.vertx.fileSystem().readFileBlocking(givenAggregate.filename()).toJsonObject();
        AggregateState state = this.getState(this.es4jBootstrapper.aggregateClass, jsonObject);
        CaffeineWrapper.put((AggregatePlainKey)new AggregatePlainKey(this.es4jBootstrapper.aggregateClass.getName(), state.state().aggregateId(), state.state().tenant()), state);
    }

    public <T extends Aggregate> AggregateState<T> getState(Class<T> aggregateClass, JsonObject jsonObject) {
        AggregateState aggregateState = new AggregateState(aggregateClass);
        return aggregateState.setState((Aggregate)jsonObject.mapTo(aggregateClass));
    }

    public void beforeEach(ExtensionContext context) {
        context.getTestMethod().ifPresent(testMethod -> {
            List<Tuple4<Class<? extends DatabaseConfiguration>, String, String, Integer>> databaseConfigurations;
            List<String> fileNames = this.fileConfigurations((Method)testMethod);
            if (!fileNames.isEmpty()) {
                fileNames.forEach(filename -> {
                    JsonObject configuration = Es4jBootstrapper.vertx.fileSystem().readFileBlocking(filename).toJsonObject();
                    this.LOGGER.info("Adding file configuration {} {}", filename, (Object)configuration.encodePrettily());
                    FileConfigurationCache.put((String)filename.substring(0, filename.indexOf(".")), (JsonObject)configuration);
                });
            }
            if (!(databaseConfigurations = this.databaseConfigurations((Method)testMethod)).isEmpty()) {
                databaseConfigurations.forEach(fsConfig -> {
                    JsonObject configuration = Es4jBootstrapper.vertx.fileSystem().readFileBlocking((String)fsConfig.getItem2()).toJsonObject();
                    this.LOGGER.info("Adding database configuration {} {}", fsConfig, (Object)configuration.encodePrettily());
                    DatabaseConfigurationCache.put((String)DatabaseConfigurationService.parseKey((ConfigurationKey)new ConfigurationKey(((Class)fsConfig.getItem1()).getName(), Integer.valueOf(0), (String)fsConfig.getItem3())), (JsonObject)configuration);
                });
                Optional<GivenAggregate> optionalGivenAggregate = Optional.ofNullable(testMethod.getAnnotation(GivenAggregate.class));
                optionalGivenAggregate.ifPresent(this::addAggregate);
            }
        });
    }
}

