/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.container;

import io.esastack.cabin.api.service.deploy.LibModuleLoadService;
import io.esastack.cabin.api.service.loader.ClassLoaderService;
import io.esastack.cabin.api.service.share.SharedClassService;
import io.esastack.cabin.common.exception.CabinRuntimeException;
import io.esastack.cabin.common.log.CabinLoggerFactory;
import io.esastack.cabin.common.util.CabinStringUtil;
import io.esastack.cabin.container.domain.LibModule;
import io.esastack.cabin.container.initialize.CabinBootContext;
import io.esastack.cabin.container.initialize.Initializer;
import io.esastack.cabin.container.service.CabinServiceManager;
import io.esastack.cabin.loader.archive.Archive;
import io.esastack.cabin.loader.util.ArchiveUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class CabinContainer {
    private static final Logger LOGGER;
    private static final String PATH = "loader.path";
    private final CabinBootContext cabinBootContext;
    private final AtomicBoolean started = new AtomicBoolean();
    private final long startAt = System.currentTimeMillis();

    public CabinContainer(String containerURLString, String[] moduleURLStrings, String[] bizURLStrings, String[] javaAgentURLStrings, String[] args) {
        Archive containerArchive;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cabin setup in classpath mode!");
            LOGGER.debug(CabinStringUtil.mergeStringArray((String)"Cabin container url:", (String[])new String[]{containerURLString}));
            LOGGER.debug(CabinStringUtil.mergeStringArray((String)"Cabin module urls:", (String[])moduleURLStrings));
            LOGGER.debug(CabinStringUtil.mergeStringArray((String)"Cabin biz urls:", (String[])bizURLStrings));
        }
        try {
            containerArchive = ArchiveUtils.createArchiveFromUrl((URL)this.convertString2URL(containerURLString));
        }
        catch (Throwable ex) {
            throw new CabinRuntimeException("Failed to create Cabin archive from url", ex);
        }
        this.cabinBootContext = CabinBootContext.newBuilder().cabinContainer(this).containerArchive(containerArchive).moduleUrls(this.convertString2URLs(moduleURLStrings)).bizUrls(this.mergeBizUrlWithLoaderPath(this.convertString2URLs(bizURLStrings))).javaAgentUrls(this.convertString2URLs(javaAgentURLStrings)).arguments(args).build();
    }

    public CabinContainer(String executableURLString, String[] javaAgentURLStrings, String[] args) {
        Archive executableArchive;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cabin setup in executable jar mode!");
            LOGGER.debug(CabinStringUtil.mergeStringArray((String)"Cabin executable url:", (String[])new String[]{executableURLString}));
        }
        try {
            executableArchive = ArchiveUtils.createArchiveFromUrl((URL)new URL(executableURLString));
        }
        catch (IOException e) {
            throw new CabinRuntimeException("Failed to create Cabin executable archive from url", (Throwable)e);
        }
        this.cabinBootContext = CabinBootContext.newBuilder().cabinContainer(this).containerArchive(ArchiveUtils.extractContainerArchive((Archive)executableArchive)).moduleUrls(ArchiveUtils.extractModuleURLs((Archive)executableArchive)).bizUrls(this.mergeBizUrlWithLoaderPath(ArchiveUtils.extractBizUrls((Archive)executableArchive))).javaAgentUrls(this.convertString2URLs(javaAgentURLStrings)).arguments(args).build();
    }

    public void start() {
        if (this.started.compareAndSet(false, true)) {
            long initStartTime = System.currentTimeMillis();
            CabinServiceManager.get().init();
            LOGGER.info("CabinServiceManager init cost: " + (System.currentTimeMillis() - initStartTime) + "ms");
            Initializer initializer = CabinServiceManager.get().getService(Initializer.class);
            initializer.initialize(this.cabinBootContext);
            String setUpMsg = "Cabin Container started in " + (System.currentTimeMillis() - this.startAt) + " ms.";
            LOGGER.info(setUpMsg);
            System.out.println(setUpMsg);
        }
    }

    public void stop() {
        CabinServiceManager.get().destroy();
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public Map<String, Class<?>> getExportedClasses() {
        SharedClassService sharedClassService = CabinServiceManager.get().getService(SharedClassService.class);
        Map sharedClassMap = sharedClassService.getSharedClassMap();
        if (sharedClassMap == null || sharedClassMap.isEmpty()) {
            LOGGER.error("There is no class exported by Cabin Container, please check the module dependencies");
        }
        return sharedClassMap;
    }

    public boolean moduleLoaded(String moduleName) {
        if (CabinStringUtil.isBlank((CharSequence)moduleName)) {
            return false;
        }
        LibModuleLoadService libModuleLoadService = CabinServiceManager.get().getService(LibModuleLoadService.class);
        if (libModuleLoadService == null) {
            return false;
        }
        return libModuleLoadService.getModule(moduleName) != null;
    }

    public List<String> getLoadedModule() {
        ArrayList<String> modules = new ArrayList<String>();
        LibModuleLoadService libModuleLoadService = CabinServiceManager.get().getService(LibModuleLoadService.class);
        if (libModuleLoadService != null) {
            libModuleLoadService.getAllModules().forEach(module -> modules.add(module.getName()));
        }
        return modules;
    }

    public ClassLoader getLibModuleClassLoader(String moduleName) {
        LibModuleLoadService libModuleLoadService = CabinServiceManager.get().getService(LibModuleLoadService.class);
        if (libModuleLoadService == null) {
            return null;
        }
        LibModule module = (LibModule)libModuleLoadService.getModule(moduleName);
        if (module == null) {
            return null;
        }
        return module.getClassLoader();
    }

    public ClassLoader getBizModuleClassLoader() {
        ClassLoaderService classLoaderService = CabinServiceManager.get().getService(ClassLoaderService.class);
        if (classLoaderService == null) {
            return null;
        }
        return classLoaderService.getBizModuleClassLoader();
    }

    private URL[] convertString2URLs(String[] args) {
        if (args == null || args.length == 0) {
            return new URL[0];
        }
        URL[] urls = new URL[args.length];
        for (int i = 0; i < args.length; ++i) {
            urls[i] = this.convertString2URL(args[i]);
        }
        return urls;
    }

    private URL convertString2URL(String arg) {
        try {
            return new URL(arg);
        }
        catch (MalformedURLException e) {
            throw new CabinRuntimeException(String.format("Failed to convert arg %s to URL", arg), (Throwable)e);
        }
    }

    private URL[] mergeBizUrlWithLoaderPath(URL[] bizUrls) {
        String[] paths;
        String loaderPath = System.getProperty(PATH);
        if (CabinStringUtil.isBlank((CharSequence)loaderPath)) {
            return bizUrls;
        }
        ArrayList<URL> pathUrls = new ArrayList<URL>();
        for (String path : paths = loaderPath.split(",")) {
            URL pathUrl;
            if (CabinStringUtil.isBlank((CharSequence)(path = path.trim()))) continue;
            File file = new File(path);
            if (!file.exists()) {
                throw new CabinRuntimeException(String.format("-Dloader.path contains path that does not exist: %s!", path));
            }
            if (!file.isDirectory()) {
                throw new CabinRuntimeException(String.format("-Dloader.path contains path that is not directory: %s!", path));
            }
            try {
                pathUrl = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new CabinRuntimeException(String.format("-Dloader.path contains invalid path that cannot convert to URL: %s!", path));
            }
            pathUrls.add(pathUrl);
        }
        if (pathUrls.isEmpty()) {
            return bizUrls;
        }
        URL[] mergedUrls = new URL[bizUrls.length + pathUrls.size()];
        System.arraycopy(pathUrls.toArray(new URL[0]), 0, mergedUrls, 0, pathUrls.size());
        System.arraycopy(bizUrls, 0, mergedUrls, pathUrls.size(), bizUrls.length);
        return mergedUrls;
    }

    static {
        CabinLoggerFactory.setLevel((String)System.getProperty("cabin.log.level", "INFO"));
        LOGGER = CabinLoggerFactory.getLogger(CabinContainer.class);
    }
}

