/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.container.domain;

import io.esastack.cabin.api.domain.Module;
import io.esastack.cabin.common.exception.CabinRuntimeException;
import io.esastack.cabin.common.forkjoinpool.ForkJoinPoolInitializer;
import io.esastack.cabin.common.log.CabinLoggerFactory;
import io.esastack.cabin.common.util.CabinStringUtil;
import io.esastack.cabin.common.util.ClassLoaderUtils;
import io.esastack.cabin.container.common.MainMethodRunner;
import java.net.URL;
import org.slf4j.Logger;

public class BizModule
implements Module {
    private static final Logger LOGGER = CabinLoggerFactory.getLogger(BizModule.class);
    private final URL[] urls;
    private final String name;
    private final String mainClass;
    private final String mainMethod;
    private final String[] arguments;
    private final ClassLoader classLoader;
    private final boolean unitTest;

    private BizModule(Builder builder) {
        this.urls = builder.urls;
        this.name = builder.name;
        this.mainClass = builder.mainClass;
        this.mainMethod = builder.mainMethod;
        this.arguments = builder.arguments;
        this.classLoader = builder.classLoader;
        this.unitTest = builder.unitTest;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getName() {
        return this.name;
    }

    public URL[] getUrls() {
        return this.urls;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getMainMethod() {
        return this.mainMethod;
    }

    public boolean isUnitTest() {
        return this.unitTest;
    }

    public void start() throws Throwable {
        ClassLoader oldTCCL = ClassLoaderUtils.pushTCCL((ClassLoader)this.classLoader);
        try {
            if (CabinStringUtil.isBlank((CharSequence)this.mainClass)) {
                throw new CabinRuntimeException("Main-class not found, Could not start biz module");
            }
            ForkJoinPoolInitializer.init();
            if (this.isUnitTest()) {
                LOGGER.info("Main-method is null or empty, this is running in unit test!");
                return;
            }
            MainMethodRunner mainMethodRunner = new MainMethodRunner(this.mainClass, this.mainMethod, this.arguments);
            mainMethodRunner.run();
        }
        finally {
            ClassLoaderUtils.setTCCL((ClassLoader)oldTCCL);
        }
    }

    public static class Builder {
        private URL[] urls;
        private String name;
        private String mainClass;
        private String mainMethod;
        private String[] arguments;
        private ClassLoader classLoader;
        private boolean unitTest;

        public Builder urls(URL[] urls) {
            this.urls = urls;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder mainClass(String mainClass) {
            this.mainClass = mainClass;
            return this;
        }

        public Builder mainMethod(String mainMethod) {
            this.mainMethod = mainMethod;
            return this;
        }

        public Builder arguments(String[] arguments) {
            this.arguments = arguments;
            return this;
        }

        public Builder classLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder unitTest(boolean isUnitTest) {
            this.unitTest = isUnitTest;
            return this;
        }

        public BizModule build() {
            return new BizModule(this);
        }
    }
}

