/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.container.domain;

import io.esastack.cabin.api.domain.Module;
import java.net.URL;

public class JavaAgentModule
implements Module {
    private final URL url;
    private final String name;
    private final ClassLoader classLoader;

    private JavaAgentModule(Builder builder) {
        this.url = builder.url;
        this.name = builder.name;
        this.classLoader = builder.classLoader;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getName() {
        return this.name;
    }

    public URL getUrl() {
        return this.url;
    }

    public static class Builder {
        private URL url;
        private String name;
        private ClassLoader classLoader;

        public Builder url(URL url) {
            this.url = url;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder classLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public JavaAgentModule build() {
            return new JavaAgentModule(this);
        }
    }
}

