/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.container.domain;

import io.esastack.cabin.api.domain.Module;
import io.esastack.cabin.container.domain.ExportInfo;
import io.esastack.cabin.container.domain.ImportInfo;
import io.esastack.cabin.loader.archive.Archive;
import java.util.List;

public class LibModule
implements Module {
    private final String name;
    private final int priority;
    private final Archive archive;
    private final ExportInfo exportInfo;
    private final ImportInfo importInfo;
    private final List<String> providedClasses;
    private final ClassLoader classLoader;

    private LibModule(Builder builder) {
        this.name = builder.name;
        this.archive = builder.archive;
        this.priority = builder.priority;
        this.exportInfo = builder.exportInfo;
        this.importInfo = builder.importInfo;
        this.classLoader = builder.classLoader;
        this.providedClasses = builder.providedClasses;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public Archive getArchive() {
        return this.archive;
    }

    public ExportInfo getExportInfo() {
        return this.exportInfo;
    }

    public ImportInfo getImportInfo() {
        return this.importInfo;
    }

    public List<String> getProvidedClasses() {
        return this.providedClasses;
    }

    public int compareTo(Module o) {
        return this.priority - ((LibModule)o).priority;
    }

    public static class Builder {
        private String name;
        private int priority;
        private Archive archive;
        private ExportInfo exportInfo;
        private ImportInfo importInfo;
        private List<String> providedClasses;
        private ClassLoader classLoader;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder archive(Archive archive) {
            this.archive = archive;
            return this;
        }

        public Builder exportInfo(ExportInfo exportInfo) {
            this.exportInfo = exportInfo;
            return this;
        }

        public Builder importInfo(ImportInfo importInfo) {
            this.importInfo = importInfo;
            return this;
        }

        public Builder providedClasses(List<String> providedClasses) {
            this.providedClasses = providedClasses;
            return this;
        }

        public Builder classLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public LibModule build() {
            return new LibModule(this);
        }
    }
}

