/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.container.initialize;

import io.esastack.cabin.loader.archive.Archive;
import java.net.URL;
import java.util.Map;

public class CabinBootContext {
    private final URL[] moduleUrls;
    private final URL[] bizUrls;
    private final URL[] javaAgentUrls;
    private final String[] arguments;
    private final Object cabinContainer;
    private final Archive containerArchive;
    private volatile Map<String, Archive> moduleArchives;

    private CabinBootContext(Builder builder) {
        this.moduleUrls = builder.moduleUrls;
        this.bizUrls = builder.bizUrls;
        this.javaAgentUrls = builder.javaAgentUrls;
        this.arguments = builder.arguments;
        this.cabinContainer = builder.cabinContainer;
        this.containerArchive = builder.containerArchive;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Object getCabinContainer() {
        return this.cabinContainer;
    }

    public Archive getContainerArchive() {
        return this.containerArchive;
    }

    public URL[] getModuleUrls() {
        return this.moduleUrls;
    }

    public URL[] getBizUrls() {
        return this.bizUrls;
    }

    public URL[] getJavaAgentUrls() {
        return this.javaAgentUrls;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public Map<String, Archive> getModuleArchives() {
        return this.moduleArchives;
    }

    public void setModuleArchives(Map<String, Archive> moduleArchives) {
        this.moduleArchives = moduleArchives;
    }

    public static class Builder {
        private URL[] moduleUrls;
        private URL[] bizUrls;
        private URL[] javaAgentUrls;
        private String[] arguments;
        private Object cabinContainer;
        private Archive containerArchive;

        public Builder moduleUrls(URL[] moduleUrls) {
            this.moduleUrls = moduleUrls;
            return this;
        }

        public Builder bizUrls(URL[] bizUrls) {
            this.bizUrls = bizUrls;
            return this;
        }

        public Builder javaAgentUrls(URL[] javaAgentUrls) {
            this.javaAgentUrls = javaAgentUrls;
            return this;
        }

        public Builder arguments(String[] arguments) {
            this.arguments = arguments;
            return this;
        }

        public Builder cabinContainer(Object cabinContainer) {
            this.cabinContainer = cabinContainer;
            return this;
        }

        public Builder containerArchive(Archive containerArchive) {
            this.containerArchive = containerArchive;
            return this;
        }

        public CabinBootContext build() {
            return new CabinBootContext(this);
        }
    }
}

