/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.container.initialize;

import io.esastack.cabin.common.exception.CabinRuntimeException;
import io.esastack.cabin.common.log.CabinLoggerFactory;
import io.esastack.cabin.container.initialize.CabinBootContext;
import io.esastack.cabin.container.initialize.Initializer;
import io.esastack.cabin.container.processor.BizModuleLoadProcessor;
import io.esastack.cabin.container.processor.BizModuleSetupProcessor;
import io.esastack.cabin.container.processor.ContainerStateExportProcessor;
import io.esastack.cabin.container.processor.JavaAgentModuleLoadProcessor;
import io.esastack.cabin.container.processor.LibModuleExportProcessor;
import io.esastack.cabin.container.processor.LibModuleLoadProcessor;
import io.esastack.cabin.container.processor.LibModuleMergeProcessor;
import io.esastack.cabin.container.processor.Processor;
import io.esastack.cabin.container.service.CabinServiceManager;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class DefaultInitializer
implements Initializer {
    private static final Logger LOGGER = CabinLoggerFactory.getLogger(DefaultInitializer.class);
    private final List<Processor> bootProcessors = new ArrayList<Processor>();

    public DefaultInitializer() {
        this.bootProcessors.add(CabinServiceManager.get().getService(JavaAgentModuleLoadProcessor.class));
        this.bootProcessors.add(CabinServiceManager.get().getService(BizModuleLoadProcessor.class));
        this.bootProcessors.add(CabinServiceManager.get().getService(LibModuleMergeProcessor.class));
        this.bootProcessors.add(CabinServiceManager.get().getService(LibModuleLoadProcessor.class));
        this.bootProcessors.add(CabinServiceManager.get().getService(LibModuleExportProcessor.class));
        this.bootProcessors.add(CabinServiceManager.get().getService(ContainerStateExportProcessor.class));
        this.bootProcessors.add(CabinServiceManager.get().getService(BizModuleSetupProcessor.class));
    }

    @Override
    public void initialize(CabinBootContext context) {
        for (Processor processor : this.bootProcessors) {
            try {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Start to process " + processor.getClass().getName());
                }
                long startTime = System.currentTimeMillis();
                processor.process(context);
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("Finished to process " + processor.getClass().getName() + ", cost: " + (System.currentTimeMillis() - startTime) + "ms");
            }
            catch (Throwable e) {
                throw new CabinRuntimeException(e);
            }
        }
    }
}

