/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.container.processor;

import io.esastack.cabin.api.service.loader.ClassLoaderService;
import io.esastack.cabin.common.exception.CabinRuntimeException;
import io.esastack.cabin.common.log.CabinLoggerFactory;
import io.esastack.cabin.common.util.CabinContainerUtil;
import io.esastack.cabin.container.initialize.CabinBootContext;
import io.esastack.cabin.container.processor.BizModuleSetupProcessor;
import io.esastack.cabin.container.processor.Processor;
import java.lang.reflect.Method;
import org.slf4j.Logger;

public class ContainerStateExportProcessor
implements Processor {
    private static final Logger LOGGER = CabinLoggerFactory.getLogger(BizModuleSetupProcessor.class);
    private volatile ClassLoaderService classLoaderService;

    @Override
    public void process(CabinBootContext cabinBootContext) throws CabinRuntimeException {
        ClassLoader bizClassloader = this.classLoaderService.getBizModuleClassLoader();
        if (bizClassloader == null) {
            throw new CabinRuntimeException("Biz Module has not been loaded!");
        }
        try {
            Class<?> clazzOfBiz = bizClassloader.loadClass(CabinContainerUtil.class.getName());
            Method initMethod = clazzOfBiz.getDeclaredMethod("init", Object.class, ClassLoader.class);
            initMethod.setAccessible(true);
            initMethod.invoke(null, cabinBootContext.getCabinContainer(), bizClassloader);
            initMethod.setAccessible(false);
        }
        catch (Throwable throwable) {
            String msg = String.format("Failed to init {%s} of BizModuleClassloader", CabinContainerUtil.class.getName());
            LOGGER.error(msg, throwable);
            throw new CabinRuntimeException(msg, throwable);
        }
    }

    public void setClassLoaderService(ClassLoaderService service) {
        this.classLoaderService = service;
    }
}

