/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.container.processor;

import io.esastack.cabin.api.domain.Module;
import io.esastack.cabin.api.service.deploy.LibModuleLoadService;
import io.esastack.cabin.api.service.share.LibModuleExportService;
import io.esastack.cabin.common.exception.CabinRuntimeException;
import io.esastack.cabin.common.log.CabinLoggerFactory;
import io.esastack.cabin.container.initialize.CabinBootContext;
import io.esastack.cabin.container.processor.Processor;
import io.esastack.cabin.container.service.share.LazyLoadExportDetector;
import io.esastack.cabin.container.service.share.LibModuleExportServiceImpl;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

public class LibModuleExportProcessor
implements Processor {
    private static final Logger LOGGER = CabinLoggerFactory.getLogger(LibModuleExportProcessor.class);
    private volatile LibModuleLoadService libModuleLoadService;
    private volatile LibModuleExportService libModuleExportService;

    @Override
    public void process(CabinBootContext cabinBootContext) throws CabinRuntimeException {
        List modules = this.libModuleLoadService.getAllModules();
        AtomicReference exportError = new AtomicReference();
        if (modules != null && modules.size() > 0) {
            CountDownLatch latch = new CountDownLatch(modules.size());
            int threadIndex = 1;
            for (Module module : modules) {
                new Thread(() -> {
                    try {
                        int count = this.libModuleExportService.exportResources(module.getName());
                        LOGGER.info("Exported {} resources from module {}", (Object)count, (Object)module.getName());
                        count = this.libModuleExportService.exportClasses(module.getName());
                        LOGGER.info("Exported {} classes from module {}", (Object)count, (Object)module.getName());
                    }
                    catch (Throwable ex) {
                        exportError.set(ex);
                        LOGGER.error("Failed to export module!", ex);
                    }
                    finally {
                        latch.countDown();
                    }
                }, "LibModuleExportThread-" + threadIndex++).start();
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new CabinRuntimeException((Throwable)e);
            }
            if (exportError.get() != null) {
                throw new CabinRuntimeException("Failed to load classes and resources from module!", (Throwable)exportError.get());
            }
            if (!LazyLoadExportDetector.isLazyLoad()) {
                this.libModuleExportService.preLoadAllSharedClasses();
            }
        }
    }

    public void setLibModuleLoadService(LibModuleLoadService service) {
        this.libModuleLoadService = service;
    }

    public void setLibModuleExportService(LibModuleExportServiceImpl service) {
        this.libModuleExportService = service;
    }
}

