/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.container.processor;

import io.esastack.cabin.common.exception.CabinRuntimeException;
import io.esastack.cabin.common.log.CabinLoggerFactory;
import io.esastack.cabin.common.util.CabinStringUtil;
import io.esastack.cabin.container.initialize.CabinBootContext;
import io.esastack.cabin.container.processor.Processor;
import io.esastack.cabin.loader.archive.Archive;
import io.esastack.cabin.loader.util.ArchiveUtils;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class LibModuleMergeProcessor
implements Processor {
    private static final Logger LOGGER = CabinLoggerFactory.getLogger(LibModuleMergeProcessor.class);
    private static final Boolean ignoreDuplicatedNestModule = Boolean.parseBoolean(System.getProperty("cabin.module.duplicated.ignore", "true"));

    @Override
    public void process(CabinBootContext cabinBootContext) throws CabinRuntimeException {
        try {
            Map<String, Archive> containerModules = this.parseLibModulesFromContainerArchive(cabinBootContext.getContainerArchive());
            Map<String, Archive> modules = this.parseLibModulesFromURLs(cabinBootContext.getModuleUrls());
            modules.putAll(containerModules);
            cabinBootContext.setModuleArchives(this.parseNestLibModulesRecursively(modules));
        }
        catch (IOException e) {
            throw new CabinRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private Map<String, Archive> parseLibModulesFromContainerArchive(Archive containerArchive) throws IOException {
        List nestModules = containerArchive.getNestedArchives(entry -> !entry.isDirectory() && entry.getName().startsWith("modules/") && entry.getName().endsWith(".jar"));
        List containerArchives = containerArchive.getNestedArchives(entry -> entry.isDirectory() && entry.getName().endsWith("conf/") || !entry.isDirectory() && entry.getName().startsWith("libs/") && entry.getName().endsWith(".jar"));
        if (LOGGER.isDebugEnabled()) {
            URL[] urls = new URL[containerArchives.size()];
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = ((Archive)containerArchives.get(i)).getUrl();
            }
            URL[] moduleUrls = new URL[nestModules.size()];
            for (int i = 0; i < moduleUrls.length; ++i) {
                moduleUrls[i] = ((Archive)nestModules.get(i)).getUrl();
            }
            LOGGER.debug(CabinStringUtil.urlsToString((String)"Cabin container classpath:", (URL[])urls));
            LOGGER.debug(CabinStringUtil.urlsToString((String)"Cabin container nested modules:", (URL[])moduleUrls));
        }
        HashMap<String, Archive> containerModules = new HashMap<String, Archive>();
        for (Archive nestModule : nestModules) {
            String moduleName = nestModule.getManifest().getMainAttributes().getValue("Module-Name");
            if (CabinStringUtil.isBlank((CharSequence)moduleName)) {
                throw new CabinRuntimeException("Invalid module Manifest, blank Module-Name, " + nestModule.getUrl().toExternalForm());
            }
            if (containerModules.put(moduleName, nestModule) == null) continue;
            throw new CabinRuntimeException(String.format("Duplicated module {%s} found in Cabin container archive", moduleName));
        }
        return containerModules;
    }

    private Map<String, Archive> parseLibModulesFromURLs(URL[] moduleUrls) throws IOException {
        HashMap<String, Archive> urlModules = new HashMap<String, Archive>();
        if (moduleUrls != null) {
            for (URL moduleUrl : moduleUrls) {
                Archive module = ArchiveUtils.createArchiveFromUrl((URL)moduleUrl);
                String moduleName = module.getManifest().getMainAttributes().getValue("Module-Name");
                if (CabinStringUtil.isBlank((CharSequence)moduleName)) {
                    throw new CabinRuntimeException("Invalid module Manifest, blank Module-Name, " + moduleUrl.toExternalForm());
                }
                if (urlModules.put(moduleName, module) == null) continue;
                throw new CabinRuntimeException(String.format("Duplicated module {%s} found in biz urls", moduleName));
            }
        }
        return urlModules;
    }

    private Map<String, Archive> parseNestLibModulesRecursively(Map<String, Archive> modules) throws IOException {
        HashMap<String, Archive> mergedModules = new HashMap<String, Archive>();
        Map<String, Archive> modules4Check = modules;
        while (modules4Check.size() > 0) {
            HashMap<String, Archive> nestedModules = new HashMap<String, Archive>();
            for (Map.Entry<String, Archive> entry : modules4Check.entrySet()) {
                Archive archive = entry.getValue();
                List nestArchives = archive.getNestedArchives(a -> !a.isDirectory() && a.getName().startsWith("modules/") && a.getName().endsWith(".jar"));
                for (Archive nestArchive : nestArchives) {
                    String moduleName = nestArchive.getManifest().getMainAttributes().getValue("Module-Name");
                    if (CabinStringUtil.isBlank((CharSequence)moduleName)) {
                        throw new CabinRuntimeException("Invalid module Manifest, blank Module-Name, " + nestArchive.getUrl().toExternalForm());
                    }
                    if (modules.containsKey(moduleName)) {
                        LOGGER.info("Duplicated module named {} found, URL {}(imported by biz url) would be used, {} is ignored!", new Object[]{moduleName, modules.get(moduleName).getUrl().toExternalForm(), nestArchive.getUrl().toExternalForm()});
                        continue;
                    }
                    if (mergedModules.containsKey(moduleName)) {
                        String errorMsg = String.format("Duplicated nested module named {%s} found, URL {%s} would be used, {%s} is ignored! if you want resolve this problem, put this cabin module in your biz dependencies.", moduleName, ((Archive)mergedModules.get(moduleName)).getUrl().toExternalForm(), nestArchive.getUrl().toExternalForm());
                        if (!ignoreDuplicatedNestModule.booleanValue()) {
                            throw new CabinRuntimeException(errorMsg);
                        }
                        LOGGER.warn(errorMsg);
                        continue;
                    }
                    nestedModules.put(moduleName, nestArchive);
                    mergedModules.put(moduleName, nestArchive);
                }
            }
            modules4Check = nestedModules;
        }
        mergedModules.putAll(modules);
        return mergedModules;
    }
}

