/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.container.service;

import io.esastack.cabin.api.service.deploy.BizModuleFactoryService;
import io.esastack.cabin.api.service.deploy.BizModuleLoadService;
import io.esastack.cabin.api.service.deploy.JavaAgentModuleFactoryService;
import io.esastack.cabin.api.service.deploy.JavaAgentModuleLoadService;
import io.esastack.cabin.api.service.deploy.LibModuleFactoryService;
import io.esastack.cabin.api.service.deploy.LibModuleLoadService;
import io.esastack.cabin.api.service.loader.ClassLoaderService;
import io.esastack.cabin.api.service.share.LibModuleExportService;
import io.esastack.cabin.api.service.share.SharedClassService;
import io.esastack.cabin.api.service.share.SharedResourceService;
import io.esastack.cabin.common.exception.CabinRuntimeException;
import io.esastack.cabin.common.log.CabinLoggerFactory;
import io.esastack.cabin.common.util.ClassLoaderUtils;
import io.esastack.cabin.container.initialize.DefaultInitializer;
import io.esastack.cabin.container.initialize.Initializer;
import io.esastack.cabin.container.processor.BizModuleLoadProcessor;
import io.esastack.cabin.container.processor.BizModuleSetupProcessor;
import io.esastack.cabin.container.processor.ContainerStateExportProcessor;
import io.esastack.cabin.container.processor.JavaAgentModuleLoadProcessor;
import io.esastack.cabin.container.processor.LibModuleExportProcessor;
import io.esastack.cabin.container.processor.LibModuleLoadProcessor;
import io.esastack.cabin.container.processor.LibModuleMergeProcessor;
import io.esastack.cabin.container.service.deploy.BizModuleFactoryServiceImpl;
import io.esastack.cabin.container.service.deploy.BizModuleLoadServiceImpl;
import io.esastack.cabin.container.service.deploy.JavaAgentModuleFactoryServiceImpl;
import io.esastack.cabin.container.service.deploy.JavaAgentModuleLoadServiceImpl;
import io.esastack.cabin.container.service.deploy.LibModuleFactoryServiceImpl;
import io.esastack.cabin.container.service.deploy.LibModuleLoadServiceImpl;
import io.esastack.cabin.container.service.loader.ClassLoaderServiceImpl;
import io.esastack.cabin.container.service.share.LibModuleExportServiceImpl;
import io.esastack.cabin.container.service.share.SharedClassServiceImpl;
import io.esastack.cabin.container.service.share.SharedResourceServiceImpl;
import java.util.concurrent.atomic.AtomicBoolean;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoBuilder;
import org.slf4j.Logger;

public class CabinServiceManager {
    private static final Logger LOGGER = CabinLoggerFactory.getLogger(CabinServiceManager.class);
    private static final CabinServiceManager singleton = new CabinServiceManager();
    private final AtomicBoolean inited = new AtomicBoolean(false);
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private final MutablePicoContainer picoContainer = new PicoBuilder().withSetterInjection().withCaching().build();

    private CabinServiceManager() {
        try {
            this.picoContainer.addComponent(JavaAgentModuleLoadService.class, JavaAgentModuleLoadServiceImpl.class, new Parameter[0]);
            this.picoContainer.addComponent(BizModuleLoadService.class, BizModuleLoadServiceImpl.class, new Parameter[0]);
            this.picoContainer.addComponent(LibModuleLoadService.class, LibModuleLoadServiceImpl.class, new Parameter[0]);
            this.picoContainer.addComponent(JavaAgentModuleFactoryService.class, JavaAgentModuleFactoryServiceImpl.class, new Parameter[0]);
            this.picoContainer.addComponent(BizModuleFactoryService.class, BizModuleFactoryServiceImpl.class, new Parameter[0]);
            this.picoContainer.addComponent(LibModuleFactoryService.class, LibModuleFactoryServiceImpl.class, new Parameter[0]);
            this.picoContainer.addComponent(ClassLoaderService.class, ClassLoaderServiceImpl.class, new Parameter[0]);
            this.picoContainer.addComponent(SharedClassService.class, SharedClassServiceImpl.class, new Parameter[0]);
            this.picoContainer.addComponent(SharedResourceService.class, SharedResourceServiceImpl.class, new Parameter[0]);
            this.picoContainer.addComponent(LibModuleExportService.class, LibModuleExportServiceImpl.class, new Parameter[0]);
            this.picoContainer.addComponent(Initializer.class, DefaultInitializer.class, new Parameter[0]);
            this.picoContainer.addComponent(JavaAgentModuleLoadProcessor.class, JavaAgentModuleLoadProcessor.class, new Parameter[0]);
            this.picoContainer.addComponent(BizModuleLoadProcessor.class, BizModuleLoadProcessor.class, new Parameter[0]);
            this.picoContainer.addComponent(LibModuleMergeProcessor.class, LibModuleMergeProcessor.class, new Parameter[0]);
            this.picoContainer.addComponent(LibModuleLoadProcessor.class, LibModuleLoadProcessor.class, new Parameter[0]);
            this.picoContainer.addComponent(LibModuleExportProcessor.class, LibModuleExportProcessor.class, new Parameter[0]);
            this.picoContainer.addComponent(ContainerStateExportProcessor.class, ContainerStateExportProcessor.class, new Parameter[0]);
            this.picoContainer.addComponent(BizModuleSetupProcessor.class, BizModuleSetupProcessor.class, new Parameter[0]);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to create PICO Container", t);
            throw new CabinRuntimeException("Failed to create PICO Container", t);
        }
    }

    public static CabinServiceManager get() {
        return singleton;
    }

    public void init() {
        if (this.inited.compareAndSet(false, true)) {
            ClassLoader oldTCCL = ClassLoaderUtils.pushTCCL((ClassLoader)CabinServiceManager.class.getClassLoader());
            try {
                this.picoContainer.start();
            }
            finally {
                ClassLoaderUtils.setTCCL((ClassLoader)oldTCCL);
            }
        }
    }

    public void destroy() {
        if (this.destroyed.compareAndSet(false, true)) {
            ClassLoader oldTCCL = ClassLoaderUtils.pushTCCL((ClassLoader)CabinServiceManager.class.getClassLoader());
            try {
                this.picoContainer.dispose();
            }
            finally {
                ClassLoaderUtils.setTCCL((ClassLoader)oldTCCL);
            }
        }
    }

    public <T> T getService(Class<T> serviceType) {
        return (T)this.picoContainer.getComponent(serviceType);
    }
}

