/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.container.service.deploy;

import io.esastack.cabin.api.service.deploy.BizModuleFactoryService;
import io.esastack.cabin.api.service.loader.BizModuleClassLoaderParam;
import io.esastack.cabin.api.service.loader.ClassLoaderService;
import io.esastack.cabin.common.exception.CabinRuntimeException;
import io.esastack.cabin.common.util.CabinStringUtil;
import io.esastack.cabin.container.domain.BizModule;
import java.net.URL;

public class BizModuleFactoryServiceImpl
implements BizModuleFactoryService<BizModule> {
    private volatile ClassLoaderService classLoaderService;

    public void setClassLoaderService(ClassLoaderService service) {
        this.classLoaderService = service;
    }

    public BizModule createModule(URL[] bizUrls, String[] args) throws CabinRuntimeException {
        boolean isUnitTest = CabinStringUtil.isNotBlank((CharSequence)args[0]) && CabinStringUtil.isNotBlank((CharSequence)args[1]) && args[0].equals("io.esastack.cabin.unit.test.fake.MainClass") && args[1].equals("unitTestMainMethod");
        BizModuleClassLoaderParam param = BizModuleClassLoaderParam.newBuilder().urls(bizUrls).isUnitTest(isUnitTest).build();
        ClassLoader classLoader = this.classLoaderService.createBizModuleClassLoader(param);
        return BizModule.newBuilder().name("Biz Identity").urls(bizUrls).mainClass(args[0]).mainMethod(args[1]).arguments(this.getRealArguments(args)).classLoader(classLoader).unitTest(isUnitTest).build();
    }

    private String[] getRealArguments(String[] args) {
        assert (args.length >= 2);
        String[] arguments = new String[args.length - 2];
        if (args.length > 2) {
            System.arraycopy(args, 2, arguments, 0, args.length - 2);
        }
        return arguments;
    }
}

