/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.container.service.deploy;

import io.esastack.cabin.api.service.deploy.JavaAgentModuleFactoryService;
import io.esastack.cabin.api.service.deploy.JavaAgentModuleLoadService;
import io.esastack.cabin.common.log.CabinLoggerFactory;
import io.esastack.cabin.container.domain.JavaAgentModule;
import io.esastack.cabin.container.service.deploy.JavaAgentModuleFactoryServiceImpl;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;

public class JavaAgentModuleLoadServiceImpl
implements JavaAgentModuleLoadService<JavaAgentModule> {
    private static final Logger LOGGER = CabinLoggerFactory.getLogger(JavaAgentModuleLoadServiceImpl.class);
    private final ConcurrentMap<String, JavaAgentModule> javaAgentModules = new ConcurrentHashMap<String, JavaAgentModule>();
    private volatile JavaAgentModuleFactoryService<JavaAgentModule> moduleFactory;

    public void setModuleFactory(JavaAgentModuleFactoryServiceImpl service) {
        this.moduleFactory = service;
    }

    public void loadModule(URL agentUrl) {
        String agentModuleName = agentUrl.toExternalForm();
        if (this.javaAgentModules.containsKey(agentModuleName)) {
            LOGGER.error("Duplicated agent URL found for: " + agentModuleName);
            return;
        }
        if (this.javaAgentModules.computeIfAbsent(agentModuleName, agent -> (JavaAgentModule)this.moduleFactory.createModule(agentUrl)) != null) {
            LOGGER.error("Duplicated agent URL found for: " + agentModuleName);
        }
    }

    public List<JavaAgentModule> getModules() {
        return new ArrayList<JavaAgentModule>(this.javaAgentModules.values());
    }
}

