/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.container.service.deploy;

import io.esastack.cabin.api.service.deploy.LibModuleFactoryService;
import io.esastack.cabin.api.service.loader.ClassLoaderService;
import io.esastack.cabin.api.service.loader.LibModuleClassLoaderParam;
import io.esastack.cabin.common.exception.CabinRuntimeException;
import io.esastack.cabin.common.log.CabinLoggerFactory;
import io.esastack.cabin.common.util.CabinStringUtil;
import io.esastack.cabin.container.domain.ExportInfo;
import io.esastack.cabin.container.domain.ImportInfo;
import io.esastack.cabin.container.domain.LibModule;
import io.esastack.cabin.loader.archive.Archive;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;

public class LibModuleFactoryServiceImpl
implements LibModuleFactoryService<LibModule> {
    private static final Logger LOGGER = CabinLoggerFactory.getLogger(LibModuleFactoryServiceImpl.class);
    private volatile ClassLoaderService classLoaderService;

    public void setClassLoaderService(ClassLoaderService service) {
        this.classLoaderService = service;
    }

    private List<URL> getLibModuleClasspathUrls(Archive archive) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>();
        List nestedJarArchives = archive.getNestedArchives(entry -> entry.isDirectory() && entry.getName().endsWith("conf/") || !entry.isDirectory() && entry.getName().startsWith("libs/") && entry.getName().endsWith(".jar"));
        for (Archive a : nestedJarArchives) {
            result.add(a.getUrl());
        }
        result.add(archive.getUrl());
        return result;
    }

    public LibModule createModule(String name, Archive archive) throws CabinRuntimeException {
        URL[] urls;
        int priority = this.getPriority(name, archive);
        ExportInfo exportInfo = this.getExportInfo(name, archive);
        ImportInfo importInfo = this.getImportInfo(name, archive);
        List<String> providedClasses = this.getProvidedClasses(name, archive);
        try {
            urls = this.getLibModuleClasspathUrls(archive).toArray(new URL[0]);
        }
        catch (IOException e) {
            throw new CabinRuntimeException(String.format("Failed to get jar from libs of module {%s}", name));
        }
        LibModuleClassLoaderParam param = LibModuleClassLoaderParam.newBuilder().moduleName(name).urls(urls).providedClassList(providedClasses).importClassList(importInfo.getImportClassList()).importPackageList(importInfo.getImportPackageList()).importResources(importInfo.getImportResources()).loadFromBizClassLoader(importInfo.isLoadFromBizClassLoader()).loadFromSystemClassLoader(importInfo.isLoadFromSystemClassLoader()).build();
        ClassLoader classLoader = this.classLoaderService.createLibModuleClassLoader(param);
        return LibModule.newBuilder().name(name).priority(priority).archive(archive).exportInfo(exportInfo).importInfo(importInfo).providedClasses(providedClasses).classLoader(classLoader).build();
    }

    private int getPriority(String name, Archive archive) {
        try {
            String priority = archive.getManifest().getMainAttributes().getValue("Module-Priority");
            if (CabinStringUtil.isNotBlank((CharSequence)priority)) {
                return Integer.parseInt(priority);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to get priority from manifest of module archive: " + name, (Throwable)e);
        }
        return 100;
    }

    private String getVersion(String name, Archive archive) {
        try {
            return archive.getManifest().getMainAttributes().getValue("Module-Version");
        }
        catch (IOException e) {
            LOGGER.error("Failed to get version from manifest of module archive: " + name, (Throwable)e);
            return null;
        }
    }

    private List<String> getProvidedClasses(String name, Archive archive) {
        ArrayList<String> classes = new ArrayList<String>();
        URL providedClassFile = archive.getResource("conf/provided.classes");
        if (providedClassFile == null) {
            LOGGER.warn("Failed to find conf/provided_classes file from archive of module: " + name);
            return Collections.EMPTY_LIST;
        }
        try {
            String clazz;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(providedClassFile.openStream()));
            while ((clazz = bufferedReader.readLine()) != null) {
                if (CabinStringUtil.isBlank((CharSequence)clazz)) continue;
                clazz = clazz.trim();
                classes.add(clazz);
            }
            return classes;
        }
        catch (IOException e) {
            throw new CabinRuntimeException("Failed open conf/provided_classes file from archive of module: " + name, (Throwable)e);
        }
    }

    private ExportInfo getExportInfo(String name, Archive archive) {
        ExportInfo exportInfo = new ExportInfo();
        try {
            String exportClasses = archive.getManifest().getMainAttributes().getValue("Export-Classes");
            if (!CabinStringUtil.isBlank((CharSequence)exportClasses)) {
                exportInfo.addClasses(Arrays.asList(exportClasses.split(",")));
            }
        }
        catch (Throwable e) {
            LOGGER.error("Failed to get Export-Classes from manifest of module archive: " + name, e);
        }
        try {
            String exportPackages = archive.getManifest().getMainAttributes().getValue("Export-Packages");
            if (!CabinStringUtil.isBlank((CharSequence)exportPackages)) {
                exportInfo.addPackages(Arrays.asList(exportPackages.split(",")));
            }
        }
        catch (Throwable e) {
            LOGGER.error("Failed to get Export-Packages from manifest of module archive: " + name, e);
        }
        try {
            String exportJars = archive.getManifest().getMainAttributes().getValue("Export-Jars");
            if (!CabinStringUtil.isBlank((CharSequence)exportJars)) {
                exportInfo.addJars(Arrays.asList(exportJars.split(",")));
            }
        }
        catch (Throwable e) {
            LOGGER.error("Failed to get Export-Jars from manifest of module archive: " + name, e);
        }
        return exportInfo;
    }

    private ImportInfo getImportInfo(String name, Archive archive) {
        ImportInfo importInfo = new ImportInfo();
        try {
            String importClasses = archive.getManifest().getMainAttributes().getValue("Import-Classes");
            if (!CabinStringUtil.isBlank((CharSequence)importClasses)) {
                importInfo.addClasses(Arrays.asList(importClasses.split(",")));
            }
        }
        catch (Throwable e) {
            LOGGER.error("Failed to get Import-Packages from manifest of module archive: " + name, e);
        }
        try {
            String importPackages = archive.getManifest().getMainAttributes().getValue("Import-Packages");
            if (!CabinStringUtil.isBlank((CharSequence)importPackages)) {
                importInfo.addPackages(Arrays.asList(importPackages.split(",")));
            }
        }
        catch (Throwable e) {
            LOGGER.error("Failed to get Import-Packages from manifest of module archive: " + name, e);
        }
        try {
            String importResources = archive.getManifest().getMainAttributes().getValue("Import-Resources");
            if (!CabinStringUtil.isBlank((CharSequence)importResources)) {
                importInfo.addImportResources(Arrays.asList(importResources.split(",")));
            }
        }
        catch (Throwable e) {
            LOGGER.error("Failed to get Import-Resources from manifest of module archive: " + name, e);
        }
        try {
            String loadFromBizClassLoader = archive.getManifest().getMainAttributes().getValue("LoadFromBizClassLoader");
            if (!CabinStringUtil.isBlank((CharSequence)loadFromBizClassLoader)) {
                importInfo.setLoadFromBizClassLoader(Boolean.parseBoolean(loadFromBizClassLoader));
            }
        }
        catch (Throwable e) {
            LOGGER.error("Failed to get LoadFromBizClassLoader from manifest of module archive: " + name, e);
        }
        try {
            importInfo.setLoadFromSystemClassLoader(Boolean.getBoolean("loadFromSystemClassLoader"));
        }
        catch (Throwable e) {
            LOGGER.error("Failed to parse oadFromSystemClassLoader from system properties", e);
        }
        return importInfo;
    }
}

