/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.container.service.deploy;

import io.esastack.cabin.api.domain.Module;
import io.esastack.cabin.api.service.deploy.LibModuleFactoryService;
import io.esastack.cabin.api.service.deploy.LibModuleLoadService;
import io.esastack.cabin.common.exception.CabinRuntimeException;
import io.esastack.cabin.common.log.CabinLoggerFactory;
import io.esastack.cabin.container.domain.LibModule;
import io.esastack.cabin.container.service.deploy.LibModuleFactoryServiceImpl;
import io.esastack.cabin.loader.archive.Archive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;

public class LibModuleLoadServiceImpl
implements LibModuleLoadService {
    private static Logger LOGGER = CabinLoggerFactory.getLogger(LibModuleLoadServiceImpl.class);
    private final ConcurrentMap<String, LibModule> modules = new ConcurrentHashMap<String, LibModule>();
    private volatile LibModuleFactoryService<LibModule> moduleFactory;

    public void setModuleFactory(LibModuleFactoryServiceImpl service) {
        this.moduleFactory = service;
    }

    public Module loadModule(String name, Archive archive) throws CabinRuntimeException {
        LibModule module = (LibModule)this.moduleFactory.createModule(name, archive);
        LibModule prevModule = this.modules.putIfAbsent(name, module);
        if (prevModule != null) {
            throw new CabinRuntimeException("Duplicated module found for module name: " + name);
        }
        return module;
    }

    public Module getModule(String name) {
        return (Module)this.modules.get(name);
    }

    public List<Module> getAllModules() {
        ArrayList<Module> moduleList = new ArrayList<Module>(this.modules.values());
        Collections.sort(moduleList);
        return moduleList;
    }
}

