/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.container.service.loader;

import io.esastack.cabin.api.service.loader.ClassLoaderService;
import io.esastack.cabin.api.service.share.SharedClassService;
import io.esastack.cabin.api.service.share.SharedResourceService;
import io.esastack.cabin.common.CompoundEnumeration;
import io.esastack.cabin.common.constant.Constants;
import io.esastack.cabin.common.exception.CabinLoaderException;
import io.esastack.cabin.common.exception.CabinRuntimeException;
import io.esastack.cabin.common.log.CabinLoggerFactory;
import io.esastack.cabin.common.util.CabinStringUtil;
import io.esastack.cabin.container.service.CabinServiceManager;
import io.esastack.cabin.loader.jar.Handler;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import org.slf4j.Logger;

public abstract class AbstractClassLoader
extends URLClassLoader {
    private static final Logger LOGGER = CabinLoggerFactory.getLogger(AbstractClassLoader.class);
    private static final String[] CABIN_LOAD_PACKAGES = new String[]{"io.esastack.cabin.api", "io.esastack.cabin.common", "io.esastack.cabin.loader", "io.esastack.cabin.support.bootstrap"};
    protected final String moduleName;
    protected final ClassLoaderService classLoaderService = CabinServiceManager.get().getService(ClassLoaderService.class);
    protected final SharedClassService sharedClassService = CabinServiceManager.get().getService(SharedClassService.class);
    protected final SharedResourceService sharedResourceService = CabinServiceManager.get().getService(SharedResourceService.class);

    public AbstractClassLoader(String moduleName, URL[] urls) {
        super(urls, (ClassLoader)null);
        this.moduleName = moduleName;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info(CabinStringUtil.urlsToString((String)("ClassLoader URLs of Module {" + moduleName + "} : "), (URL[])urls));
        }
    }

    public String getModuleName() {
        return this.moduleName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws CabinLoaderException {
        if (CabinStringUtil.isBlank((CharSequence)name)) {
            throw new CabinRuntimeException("class name is blank");
        }
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> clazz;
            Handler.setUseFastConnectionExceptions((boolean)true);
            try {
                this.doDefinePackage(name);
                Class<?> clazz2 = this.loadClass0(name, resolve);
                if (resolve) {
                    this.resolveClass(clazz2);
                }
                clazz = clazz2;
            }
            catch (Throwable throwable) {
                Handler.setUseFastConnectionExceptions((boolean)false);
                throw throwable;
            }
            Handler.setUseFastConnectionExceptions((boolean)false);
            return clazz;
        }
    }

    private void doDefinePackage(String clazzName) {
        String packName;
        int lastIndex = clazzName.lastIndexOf(46);
        if (lastIndex >= 0 && this.getPackage(packName = clazzName.substring(0, lastIndex)) == null) {
            try {
                this.doDefinePackage(clazzName, packName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void doDefinePackage(String clazzName, String packName) {
        try {
            AccessController.doPrivileged(() -> {
                StringBuilder packBuf = new StringBuilder();
                StringBuilder clazzBuf = new StringBuilder();
                String packageEntryName = packBuf.append(packName.replace('.', '/')).append("/").toString();
                String classEntryName = clazzBuf.append(clazzName.replace('.', '/')).append(".class").toString();
                for (URL url : this.getURLs()) {
                    try {
                        JarFile jarFile;
                        URLConnection connection = url.openConnection();
                        if (!(connection instanceof JarURLConnection) || (jarFile = ((JarURLConnection)connection).getJarFile()).getEntry(classEntryName) == null || jarFile.getEntry(packageEntryName) == null || jarFile.getManifest() == null) continue;
                        this.definePackage(packName, jarFile.getManifest(), url);
                        return null;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return null;
            }, AccessController.getContext());
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Handler.setUseFastConnectionExceptions((boolean)true);
        try {
            if (name == null) {
                throw new CabinRuntimeException("Could not find resource for null");
            }
            Enumeration<URL> enumeration = this.getResources0(name);
            return enumeration;
        }
        finally {
            Handler.setUseFastConnectionExceptions((boolean)false);
        }
    }

    @Override
    public URL getResource(String name) {
        Handler.setUseFastConnectionExceptions((boolean)true);
        try {
            if (name == null) {
                throw new NullPointerException();
            }
            URL uRL = this.getResource0(name);
            return uRL;
        }
        finally {
            Handler.setUseFastConnectionExceptions((boolean)false);
        }
    }

    protected abstract Class<?> loadClass0(String var1, boolean var2) throws CabinLoaderException;

    protected abstract Enumeration<URL> getResources0(String var1) throws IOException;

    protected abstract URL getResource0(String var1);

    public Class<?> loadClassFromClasspath(String name) throws CabinLoaderException {
        Class<?> clazz = this.loadFromRecords(name);
        if (clazz == null) {
            clazz = this.loadLocalClass(name);
        }
        return clazz;
    }

    protected Class<?> loadImportClassFromBiz(String name) throws CabinLoaderException {
        if (this.shouldImportClassFromBiz(name)) {
            try {
                Class<?> clazz = ((AbstractClassLoader)this.classLoaderService.getBizModuleClassLoader()).loadClassFromClasspath(name);
                if (clazz != null) {
                    return clazz;
                }
            }
            catch (Throwable t) {
                throw new CabinLoaderException("Failed to load from biz classloader", t);
            }
            LOGGER.warn("Cannot load imported class {} of module {} from biz classloader", (Object)name, (Object)this.getModuleName());
        }
        return null;
    }

    protected Class<?> loadFromRecords(String name) throws CabinLoaderException {
        try {
            return this.findLoadedClass(name);
        }
        catch (Throwable t) {
            throw new CabinLoaderException(String.format("Failed to find %s from loaded classes", name), t);
        }
    }

    protected Class<?> loadJdkClass(String name) throws CabinLoaderException {
        try {
            return this.classLoaderService.getExtClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Throwable e) {
            throw new CabinLoaderException(String.format("Failed to load %s from jdk classes", name), e);
        }
        return null;
    }

    protected Class<?> loadCabinClass(String name) throws CabinLoaderException {
        boolean shouldLoad = false;
        for (String pkg : CABIN_LOAD_PACKAGES) {
            if (!name.startsWith(pkg)) continue;
            shouldLoad = true;
            break;
        }
        if (shouldLoad) {
            try {
                return this.classLoaderService.getCabinClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Throwable t) {
                throw new CabinLoaderException(String.format("Failed to load class %s from container classloader", name), t);
            }
        }
        return null;
    }

    protected Class<?> loadSharedClass(String name) throws CabinLoaderException {
        if (this.sharedClassService != null) {
            try {
                return this.sharedClassService.getSharedClass(name);
            }
            catch (Throwable t) {
                throw new CabinLoaderException(String.format("Failed to load %s from shared classes", name), t);
            }
        }
        return null;
    }

    protected Class<?> loadBizClass(String name) throws CabinLoaderException {
        try {
            return ((AbstractClassLoader)this.classLoaderService.getBizModuleClassLoader()).loadClassFromClasspath(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (Throwable t) {
            throw new CabinLoaderException("Failed to load from biz classloader", t);
        }
    }

    protected Class<?> loadLocalClass(String name) throws CabinLoaderException {
        try {
            return this.findClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Throwable t) {
            throw new CabinLoaderException(String.format("Failed to load %s from classpath", name), t);
        }
        return null;
    }

    protected Class<?> loadAgentClass(String name) throws CabinLoaderException {
        for (Map.Entry entry : this.classLoaderService.getJavaAgentModuleClassLoaders().entrySet()) {
            String agentUrl = (String)entry.getKey();
            AbstractClassLoader classLoader = (AbstractClassLoader)entry.getValue();
            try {
                Class<?> clazz = classLoader.loadClassFromClasspath(name);
                if (clazz == null) continue;
                return clazz;
            }
            catch (ClassNotFoundException clazz) {
            }
            catch (Throwable t) {
                throw new CabinLoaderException(String.format("Failed to load agent class %s from Agent classloader of %s", name, agentUrl), t);
            }
        }
        return null;
    }

    protected Enumeration<URL> getJdkResources(String name) throws IOException {
        return this.classLoaderService.getExtClassLoader().getResources(name);
    }

    protected Enumeration<URL> getLocalResources(String name) throws IOException {
        return super.getResources(name);
    }

    protected Enumeration<URL> getExportResources(String name) throws IOException {
        ArrayList<Enumeration<URL>> enumerations = new ArrayList<Enumeration<URL>>();
        List classLoaders = this.sharedResourceService.getResourceClassLoaders(name);
        if (classLoaders != null) {
            for (ClassLoader classLoader : classLoaders) {
                enumerations.add(((AbstractClassLoader)classLoader).getLocalResources(name));
            }
        }
        return new CompoundEnumeration(enumerations.toArray(new Enumeration[0]));
    }

    protected Enumeration<URL> getBizResources(String name) throws IOException {
        return ((AbstractClassLoader)this.classLoaderService.getBizModuleClassLoader()).getLocalResources(name);
    }

    protected Enumeration<URL> getJavaAgentResources(String name) throws IOException {
        ArrayList<Enumeration<URL>> enumerations = new ArrayList<Enumeration<URL>>();
        for (ClassLoader classLoader : this.classLoaderService.getJavaAgentModuleClassLoaders().values()) {
            enumerations.add(((AbstractClassLoader)classLoader).getLocalResources(name));
        }
        return new CompoundEnumeration(enumerations.toArray(new Enumeration[0]));
    }

    protected URL getJdkResource(String name) {
        return this.classLoaderService.getExtClassLoader().getResource(name);
    }

    protected URL getLocalResource(String name) {
        return super.getResource(name);
    }

    protected URL getExportResource(String name) {
        List classLoaders = this.sharedResourceService.getResourceClassLoaders(name);
        if (classLoaders != null) {
            for (ClassLoader classLoader : classLoaders) {
                URL resource = ((AbstractClassLoader)classLoader).getLocalResource(name);
                if (resource == null) continue;
                return resource;
            }
        }
        return null;
    }

    protected URL getBizResource(String name) {
        return ((AbstractClassLoader)this.classLoaderService.getBizModuleClassLoader()).getLocalResource(name);
    }

    protected URL getJavaAgentResource(String name) {
        for (ClassLoader classLoader : this.classLoaderService.getJavaAgentModuleClassLoaders().values()) {
            URL resource = ((AbstractClassLoader)classLoader).getLocalResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    protected boolean shouldImportClassFromBiz(String name) {
        if (Constants.IMPORT_PKG_ENABLE) {
            for (String packageName : Constants.DEFAULT_IMPORT_PKG) {
                if (!CabinStringUtil.isNotBlank((CharSequence)packageName) || !name.startsWith(packageName)) continue;
                return true;
            }
        }
        for (String packageName : Constants.CUSTOM_IMPORT_PKG) {
            if (!CabinStringUtil.isNotBlank((CharSequence)packageName) || !name.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    protected void debugClassLoadMessage(Class<?> clazz, String method, String className) {
        if (LOGGER.isDebugEnabled()) {
            String position = "unknown";
            if (clazz.getProtectionDomain() != null && clazz.getProtectionDomain().getCodeSource() != null && clazz.getProtectionDomain().getCodeSource().getLocation() != null) {
                position = clazz.getProtectionDomain().getCodeSource().getLocation().toString();
            }
            LOGGER.debug(String.format("Loaded class for Module {%s}: class {%s} in {%s} at {%s} method", this.getModuleName(), className, position, method));
        }
    }
}

