/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.container.service.loader;

import io.esastack.cabin.api.service.loader.BizModuleClassLoaderParam;
import io.esastack.cabin.api.service.loader.ClassLoaderService;
import io.esastack.cabin.api.service.loader.LibModuleClassLoaderParam;
import io.esastack.cabin.common.exception.CabinRuntimeException;
import io.esastack.cabin.common.util.CabinStringUtil;
import io.esastack.cabin.container.service.loader.BizModuleClassLoader;
import io.esastack.cabin.container.service.loader.JavaAgentClassLoader;
import io.esastack.cabin.container.service.loader.LibModuleClassLoader;
import io.esastack.cabin.container.service.loader.UnitTestModuleClassLoader;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ClassLoaderServiceImpl
implements ClassLoaderService {
    private final ClassLoader extClassLoader;
    private final ClassLoader cabinClassLoader;
    private final ConcurrentMap<String, ClassLoader> javaAgentClassLoaders = new ConcurrentHashMap<String, ClassLoader>();
    private final ConcurrentMap<String, ClassLoader> libModuleClassLoaders = new ConcurrentHashMap<String, ClassLoader>();
    private volatile ClassLoader bizModuleClassLoader;

    public ClassLoaderServiceImpl() {
        ClassLoader ext = ClassLoader.getSystemClassLoader().getParent();
        while (ext.getParent() != null) {
            ext = ext.getParent();
        }
        this.extClassLoader = ext;
        this.cabinClassLoader = this.getClass().getClassLoader();
    }

    public ClassLoader getExtClassLoader() {
        return this.extClassLoader;
    }

    public ClassLoader getCabinClassLoader() {
        return this.cabinClassLoader;
    }

    public Map<String, ClassLoader> getJavaAgentModuleClassLoaders() {
        return this.javaAgentClassLoaders;
    }

    public ClassLoader createJavaAgentModuleClassLoader(URL agentUrl) {
        JavaAgentClassLoader classLoader = new JavaAgentClassLoader(agentUrl);
        this.javaAgentClassLoaders.put(agentUrl.toExternalForm(), classLoader);
        return classLoader;
    }

    public ClassLoader getBizModuleClassLoader() {
        return this.bizModuleClassLoader;
    }

    public ClassLoader createBizModuleClassLoader(BizModuleClassLoaderParam param) {
        BizModuleClassLoader bizModuleClassLoader = param.isUnitTest() ? new UnitTestModuleClassLoader(param.getUrls()) : new BizModuleClassLoader(param.getUrls());
        this.bizModuleClassLoader = bizModuleClassLoader;
        return bizModuleClassLoader;
    }

    public ClassLoader getLibModuleClassLoader(String moduleName) {
        if (CabinStringUtil.isBlank((CharSequence)moduleName)) {
            return null;
        }
        return (ClassLoader)this.libModuleClassLoaders.get(moduleName);
    }

    public ClassLoader createLibModuleClassLoader(LibModuleClassLoaderParam param) {
        if (param == null) {
            throw new CabinRuntimeException("Param is null");
        }
        if (CabinStringUtil.isBlank((CharSequence)param.getModuleName())) {
            throw new CabinRuntimeException("Module name is blank");
        }
        if (param.getUrls() == null || param.getUrls().length == 0) {
            throw new CabinRuntimeException("Module url is empty");
        }
        URL[] urls = param.getUrls();
        LibModuleClassLoader libModuleClassLoader = new LibModuleClassLoader(param.getModuleName(), urls);
        libModuleClassLoader.setLoadFromBizClassLoader(param.isLoadFromBizClassLoader());
        libModuleClassLoader.setProvidedClasses(param.getProvidedClassList());
        libModuleClassLoader.setImportClasses(param.getImportClassList());
        libModuleClassLoader.setImportPackages(param.getImportPackageList());
        libModuleClassLoader.setImportResources(param.getImportResources());
        this.libModuleClassLoaders.put(param.getModuleName(), libModuleClassLoader);
        return libModuleClassLoader;
    }
}

