/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.container.service.loader;

import io.esastack.cabin.common.CompoundEnumeration;
import io.esastack.cabin.common.exception.CabinLoaderException;
import io.esastack.cabin.container.service.loader.AbstractClassLoader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;

public class JavaAgentClassLoader
extends AbstractClassLoader {
    private final URL agentUrl;

    public JavaAgentClassLoader(URL agentUrl) {
        super("Agent Module: " + agentUrl, new URL[]{agentUrl});
        this.agentUrl = agentUrl;
    }

    public URL getAgentUrl() {
        return this.agentUrl;
    }

    @Override
    protected Class<?> loadClass0(String name, boolean resolve) throws CabinLoaderException {
        Class<?> clazz = this.loadFromRecords(name);
        if (clazz != null) {
            this.debugClassLoadMessage(clazz, "loadFromRecords", name);
            return clazz;
        }
        clazz = this.loadJdkClass(name);
        if (clazz != null) {
            this.debugClassLoadMessage(clazz, "loadJdkClass", name);
            return clazz;
        }
        clazz = this.loadCabinClass(name);
        if (clazz != null) {
            this.debugClassLoadMessage(clazz, "loadCabinClass", name);
            return clazz;
        }
        clazz = this.loadImportClassFromBiz(name);
        if (clazz != null) {
            this.debugClassLoadMessage(clazz, "loadImportClassFromBiz", name);
            return clazz;
        }
        clazz = this.loadLocalClass(name);
        if (clazz != null) {
            this.debugClassLoadMessage(clazz, "loadLocalClass", name);
            return clazz;
        }
        clazz = this.loadSharedClass(name);
        if (clazz != null) {
            this.debugClassLoadMessage(clazz, "loadSharedClass", name);
            return clazz;
        }
        clazz = this.loadBizClass(name);
        if (clazz != null) {
            this.debugClassLoadMessage(clazz, "loadExternalBizClass", name);
            return clazz;
        }
        throw new CabinLoaderException(String.format("Could not load class {%s} from Agent: ", this.agentUrl));
    }

    @Override
    protected Enumeration<URL> getResources0(String name) throws IOException {
        ArrayList<Enumeration<URL>> enumerations = new ArrayList<Enumeration<URL>>();
        enumerations.add(this.getJdkResources(name));
        enumerations.add(this.getLocalResources(name));
        enumerations.add(this.getExportResources(name));
        enumerations.add(this.getBizResources(name));
        return new CompoundEnumeration(enumerations.toArray(new Enumeration[0]));
    }

    @Override
    protected URL getResource0(String name) {
        URL url = this.getJdkResource(name);
        if (url == null) {
            url = this.getLocalResource(name);
        }
        if (url == null) {
            url = this.getExportResource(name);
        }
        if (url == null) {
            url = this.getBizResource(name);
        }
        return url;
    }
}

