/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.container.service.loader;

import io.esastack.cabin.common.CompoundEnumeration;
import io.esastack.cabin.common.exception.CabinLoaderException;
import io.esastack.cabin.common.log.CabinLoggerFactory;
import io.esastack.cabin.common.util.CabinStringUtil;
import io.esastack.cabin.container.service.loader.AbstractClassLoader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public class LibModuleClassLoader
extends AbstractClassLoader {
    private static final Logger LOGGER = CabinLoggerFactory.getLogger(LibModuleClassLoader.class);
    private Set<String> providedClasses;
    private Set<String> importClasses;
    private List<String> importPackages;
    private List<String> importResources;
    private boolean loadFromBizClassLoader;

    public LibModuleClassLoader(String moduleName, URL[] urls) {
        super(moduleName, urls);
    }

    public void setProvidedClasses(List<String> providedClasses) {
        this.providedClasses = new HashSet<String>(providedClasses);
    }

    public void setImportClasses(List<String> importClasses) {
        this.importClasses = new HashSet<String>(importClasses);
    }

    public void setImportPackages(List<String> importPackages) {
        this.importPackages = importPackages;
    }

    public void setImportResources(List<String> importResources) {
        this.importResources = importResources;
    }

    public void setLoadFromBizClassLoader(boolean loadFromBizClassLoader) {
        this.loadFromBizClassLoader = loadFromBizClassLoader;
    }

    @Override
    protected Class<?> loadClass0(String name, boolean resolve) throws CabinLoaderException {
        Class<?> clazz = this.loadFromRecords(name);
        if (clazz != null) {
            this.debugClassLoadMessage(clazz, "loadFromRecords", name);
            return clazz;
        }
        clazz = this.loadJdkClass(name);
        if (clazz != null) {
            this.debugClassLoadMessage(clazz, "loadJdkClass", name);
            return clazz;
        }
        clazz = this.loadCabinClass(name);
        if (clazz != null) {
            this.debugClassLoadMessage(clazz, "loadCabinClass", name);
            return clazz;
        }
        clazz = this.loadSharedClass(name);
        if (clazz != null) {
            this.debugClassLoadMessage(clazz, "loadSharedClass", name);
            return clazz;
        }
        clazz = this.loadProvidedClassFromBiz(name);
        if (clazz != null) {
            this.debugClassLoadMessage(clazz, "loadProvidedClassFromBiz", name);
            return clazz;
        }
        clazz = this.loadImportClassFromBiz(name);
        if (clazz != null) {
            this.debugClassLoadMessage(clazz, "loadImportClassFromBiz", name);
            return clazz;
        }
        clazz = this.loadLocalClass(name);
        if (clazz != null) {
            this.debugClassLoadMessage(clazz, "loadLocalClass", name);
            return clazz;
        }
        clazz = this.loadExternalClassFromBiz(name);
        if (clazz != null) {
            this.debugClassLoadMessage(clazz, "loadExternalBizClass", name);
            return clazz;
        }
        clazz = this.loadAgentClass(name);
        if (clazz != null) {
            this.debugClassLoadMessage(clazz, "loadAgentClass", name);
            return clazz;
        }
        throw new CabinLoaderException(String.format("Could not load class {%s} from module {%s}", name, this.getModuleName()));
    }

    @Override
    public Enumeration<URL> getResources0(String name) throws IOException {
        ArrayList<Enumeration<URL>> enumerations = new ArrayList<Enumeration<URL>>();
        enumerations.add(this.getJdkResources(name));
        enumerations.add(this.getImportBizResources(name));
        enumerations.add(this.getLocalResources(name));
        enumerations.add(this.getExportResources(name));
        enumerations.add(this.getJavaAgentResources(name));
        return new CompoundEnumeration(enumerations.toArray(new Enumeration[0]));
    }

    @Override
    public URL getResource0(String name) {
        URL url = this.getJdkResource(name);
        if (url == null) {
            url = this.getImportBizResource(name);
        }
        if (url == null) {
            url = this.getLocalResource(name);
        }
        if (url == null) {
            url = this.getExportResource(name);
        }
        if (url == null) {
            url = this.getExternalResourceFromBiz(name);
        }
        if (url == null) {
            url = this.getJavaAgentResource(name);
        }
        return url;
    }

    private Enumeration<URL> getImportBizResources(String name) throws IOException {
        if (this.loadFromBizClassLoader && this.importResources != null && this.importResources.size() != 0) {
            for (String importResource : this.importResources) {
                if (!name.equals(importResource)) continue;
                return ((AbstractClassLoader)this.classLoaderService.getBizModuleClassLoader()).getLocalResources(name);
            }
        }
        return Collections.emptyEnumeration();
    }

    private URL getImportBizResource(String name) {
        if (this.loadFromBizClassLoader && this.importResources != null && this.importResources.size() != 0) {
            for (String importResource : this.importResources) {
                if (!name.equals(importResource)) continue;
                return ((AbstractClassLoader)this.classLoaderService.getBizModuleClassLoader()).getLocalResource(name);
            }
        }
        return null;
    }

    private URL getExternalResourceFromBiz(String name) {
        if (this.loadFromBizClassLoader) {
            return ((AbstractClassLoader)this.classLoaderService.getBizModuleClassLoader()).getLocalResource(name);
        }
        return null;
    }

    private Class<?> loadProvidedClassFromBiz(String name) throws CabinLoaderException {
        if (this.providedClasses != null && this.providedClasses.size() != 0 && this.providedClasses.contains(name)) {
            try {
                return ((AbstractClassLoader)this.classLoaderService.getBizModuleClassLoader()).loadClassFromClasspath(name);
            }
            catch (Throwable t) {
                String msg = String.format("Could not load provided class {%s} of module {%s} from biz classloader", name, this.getModuleName());
                LOGGER.error(msg, t);
                throw new CabinLoaderException(msg, t);
            }
        }
        return null;
    }

    @Override
    protected boolean shouldImportClassFromBiz(String name) {
        if (super.shouldImportClassFromBiz(name)) {
            return true;
        }
        if (this.importClasses != null && this.importClasses.contains(name)) {
            return true;
        }
        if (this.importPackages != null && this.importPackages.size() != 0) {
            for (String packageName : this.importPackages) {
                if (!CabinStringUtil.isNotBlank((CharSequence)packageName) || !name.startsWith(packageName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected Class<?> loadImportClassFromBiz(String name) throws CabinLoaderException {
        if (this.loadFromBizClassLoader) {
            return super.loadImportClassFromBiz(name);
        }
        return null;
    }

    private Class<?> loadExternalClassFromBiz(String name) throws CabinLoaderException {
        if (this.loadFromBizClassLoader) {
            return this.loadBizClass(name);
        }
        return null;
    }
}

