/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.container.service.loader;

import io.esastack.cabin.common.exception.CabinLoaderException;
import io.esastack.cabin.container.service.loader.BizModuleClassLoader;
import java.net.URL;

public class UnitTestModuleClassLoader
extends BizModuleClassLoader {
    private static final String[] PACKAGE_FOR_UNIT_TEST = new String[]{"org.junit", "junit", "org.hamcrest", "org.testng", "com.beust.jcommander", "bsh", "org.apache.catalina", "org.apache.coyote", "org.apache.juli", "org.apache.naming", "org.apache.tomcat", "org.apache.el", "javax"};

    public UnitTestModuleClassLoader(URL[] urls) {
        super("UnitTestModule", urls);
    }

    @Override
    protected Class<?> loadClass0(String name, boolean resolve) throws CabinLoaderException {
        if (this.isUnitTestClass(name)) {
            try {
                return UnitTestModuleClassLoader.getSystemClassLoader().loadClass(name);
            }
            catch (Throwable ex) {
                throw new CabinLoaderException("Failed to load unit test class " + name, ex);
            }
        }
        return super.loadClass0(name, resolve);
    }

    private boolean isUnitTestClass(String name) {
        for (String pkg : PACKAGE_FOR_UNIT_TEST) {
            if (!name.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }
}

