/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.container.service.share;

import io.esastack.cabin.api.domain.Module;
import io.esastack.cabin.api.service.share.SharedClassService;
import io.esastack.cabin.common.exception.CabinLoaderException;
import io.esastack.cabin.common.exception.CabinRuntimeException;
import io.esastack.cabin.common.log.CabinLoggerFactory;
import io.esastack.cabin.common.util.CabinStringUtil;
import io.esastack.cabin.container.domain.LibModule;
import io.esastack.cabin.container.service.loader.LibModuleClassLoader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public abstract class AbstractSharedClassService
implements SharedClassService {
    private static final Logger LOGGER = CabinLoggerFactory.getLogger(AbstractSharedClassService.class);
    private static final Map<String, Map<LibModule, Object>> packageToModuleMap = new ConcurrentHashMap<String, Map<LibModule, Object>>();
    private static final Object sentinel = new Object();

    public void addSharedPackage(String packageName, Module module) {
        if (CabinStringUtil.isBlank((CharSequence)packageName)) {
            return;
        }
        Map modules = packageToModuleMap.computeIfAbsent(packageName, name -> new ConcurrentHashMap());
        modules.put((LibModule)module, sentinel);
    }

    public Class<?> getSharedClass(String className) {
        Class<?> clazz = this.getSharedClass0(className);
        if (clazz != null) {
            return clazz;
        }
        int index = className.lastIndexOf(".");
        while (index > 0) {
            String packageName = className.substring(0, index);
            Map<LibModule, Object> modules = packageToModuleMap.get(packageName);
            if (modules != null && !modules.isEmpty()) {
                Class<?> prevLoadedClass = null;
                LibModule prevLoadedModule = null;
                for (LibModule libModule : modules.keySet()) {
                    LibModuleClassLoader classLoader = (LibModuleClassLoader)libModule.getClassLoader();
                    try {
                        clazz = classLoader.loadClassFromClasspath(className);
                    }
                    catch (CabinLoaderException e) {
                        throw new CabinRuntimeException(String.format("Failed to export class %s from module %s", className, libModule.getName()));
                    }
                    if (clazz == null) continue;
                    if (prevLoadedClass != null) {
                        throw new CabinRuntimeException(String.format("Class export conflicted, %s is exported by module %s and %s", className, prevLoadedModule.getName(), libModule.getName()));
                    }
                    prevLoadedClass = clazz;
                    prevLoadedModule = libModule;
                }
                if (prevLoadedClass != null) {
                    LOGGER.info("Trying to add class {} exported by Module {} to sharedClassService!", (Object)className, (Object)prevLoadedModule.getName());
                    this.addSharedClass(className, prevLoadedClass);
                    return prevLoadedClass;
                }
            }
            index = packageName.lastIndexOf(".");
        }
        return null;
    }

    protected abstract Class<?> getSharedClass0(String var1);
}

