/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.container.service.share;

import io.esastack.cabin.api.domain.Module;
import io.esastack.cabin.container.service.loader.LibModuleClassLoader;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LazyLoadClassMap
implements Map<String, Class<?>> {
    private final ConcurrentMap<String, Class<?>> cachedClasses;
    private final ConcurrentMap<String, Module> classToModuleMap;

    public LazyLoadClassMap(int initCapacity) {
        this.cachedClasses = new ConcurrentHashMap(initCapacity);
        this.classToModuleMap = new ConcurrentHashMap<String, Module>(initCapacity);
    }

    @Override
    public int size() {
        return this.classToModuleMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.classToModuleMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.classToModuleMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<?> get(Object key) {
        Class cachedClass = (Class)this.cachedClasses.get(key);
        if (cachedClass != null) {
            return cachedClass;
        }
        Module module = (Module)this.classToModuleMap.get(key);
        if (module == null) {
            return null;
        }
        try {
            Class<?> result = null;
            LibModuleClassLoader libModuleClassLoader = (LibModuleClassLoader)module.getClassLoader();
            if (libModuleClassLoader != null && (result = libModuleClassLoader.loadClassFromClasspath((String)key)) != null) {
                this.cachedClasses.put((String)key, result);
            }
            return result;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public Class<?> put(String key, Class<?> value) {
        return this.cachedClasses.put(key, value);
    }

    @Override
    public Class<?> putIfAbsent(String key, Class<?> value) {
        return this.cachedClasses.putIfAbsent(key, value);
    }

    @Override
    public Class<?> remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Class<?>> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Class<?>> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, Class<?>>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Module putIfAbsent(String className, Module module) {
        return this.classToModuleMap.putIfAbsent(className, module);
    }
}

