/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.container.service.share;

import io.esastack.cabin.api.domain.Module;
import io.esastack.cabin.api.service.deploy.LibModuleLoadService;
import io.esastack.cabin.api.service.share.LibModuleExportService;
import io.esastack.cabin.api.service.share.SharedClassService;
import io.esastack.cabin.api.service.share.SharedResourceService;
import io.esastack.cabin.common.exception.CabinRuntimeException;
import io.esastack.cabin.common.log.CabinLoggerFactory;
import io.esastack.cabin.common.util.CabinStringUtil;
import io.esastack.cabin.container.domain.LibModule;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import org.slf4j.Logger;

public class LibModuleExportServiceImpl
implements LibModuleExportService {
    private static final Logger LOGGER = CabinLoggerFactory.getLogger(LibModuleExportServiceImpl.class);
    private volatile SharedClassService sharedClassService;
    private volatile SharedResourceService sharedResourceService;
    private volatile LibModuleLoadService libModuleLoadService;

    public void setSharedClassService(SharedClassService service) {
        this.sharedClassService = service;
    }

    public void setSharedResourceService(SharedResourceService service) {
        this.sharedResourceService = service;
    }

    public void setLibModuleLoadService(LibModuleLoadService service) {
        this.libModuleLoadService = service;
    }

    public void preLoadAllSharedClasses() {
        this.sharedClassService.preLoadAllSharedClasses();
    }

    public int exportResources(String moduleName) throws CabinRuntimeException {
        if (CabinStringUtil.isBlank((CharSequence)moduleName)) {
            return 0;
        }
        LibModule libModule = (LibModule)this.libModuleLoadService.getModule(moduleName);
        if (libModule == null) {
            LOGGER.warn(String.format("Could not find LibModule of %s", moduleName));
            return 0;
        }
        URL exportResourcesUrl = libModule.getArchive().getResource("conf/export.resources");
        if (exportResourcesUrl == null) {
            LOGGER.info("Failed to find 'conf/export_resources' file from archive of module: " + moduleName);
            return -1;
        }
        int exportedCount = 0;
        ArrayList<String> exportResources = new ArrayList<String>();
        try {
            String resource;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(exportResourcesUrl.openStream()));
            while ((resource = bufferedReader.readLine()) != null) {
                if (!CabinStringUtil.isNotBlank((CharSequence)resource)) continue;
                resource = resource.trim();
                exportResources.add(resource.trim());
                this.sharedResourceService.addExportClassLoader(resource.trim(), libModule.getClassLoader());
                ++exportedCount;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(CabinStringUtil.mergeStringArray((String)("Module{" + moduleName + "} export resources:"), (String[])exportResources.toArray(new String[0])));
            }
        }
        catch (IOException e) {
            throw new CabinRuntimeException("Failed open conf/export_resources file from archive of module: " + moduleName, (Throwable)e);
        }
        return exportedCount;
    }

    public int exportClasses(String moduleName) throws CabinRuntimeException {
        if (CabinStringUtil.isBlank((CharSequence)moduleName)) {
            return 0;
        }
        LibModule libModule = (LibModule)this.libModuleLoadService.getModule(moduleName);
        if (libModule == null) {
            return 0;
        }
        for (String packageName : libModule.getExportInfo().getPackages()) {
            if (!CabinStringUtil.isNotBlank((CharSequence)packageName)) continue;
            this.sharedClassService.addSharedPackage(packageName, (Module)libModule);
        }
        URL exportedClassFile = libModule.getArchive().getResource("conf/export.classes");
        if (exportedClassFile == null) {
            LOGGER.warn("Failed to find conf/export_classes file from archive of module: " + moduleName);
            return -1;
        }
        int exportedCount = 0;
        ArrayList<String> exportedClasses = new ArrayList<String>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(exportedClassFile.openStream()));){
            String clazz;
            while ((clazz = bufferedReader.readLine()) != null) {
                if (!CabinStringUtil.isNotBlank((CharSequence)clazz)) continue;
                clazz = clazz.trim();
                exportedClasses.add(clazz);
                this.sharedClassService.addSharedClass(clazz, (Module)libModule);
                ++exportedCount;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(CabinStringUtil.mergeStringArray((String)("Module{" + moduleName + "} export classes:"), (String[])exportedClasses.toArray(new String[0])));
            }
        }
        catch (IOException e) {
            throw new CabinRuntimeException("Failed open conf/export_classes file from archive of module: " + moduleName, (Throwable)e);
        }
        return exportedCount;
    }
}

