/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.container.service.share;

import io.esastack.cabin.api.domain.Module;
import io.esastack.cabin.api.service.share.SharedClassService;
import io.esastack.cabin.common.exception.CabinRuntimeException;
import io.esastack.cabin.common.log.CabinLoggerFactory;
import io.esastack.cabin.common.util.CabinStringUtil;
import io.esastack.cabin.container.domain.LibModule;
import io.esastack.cabin.container.service.loader.LibModuleClassLoader;
import io.esastack.cabin.loader.jar.Handler;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class SharedClassServiceImpl
implements SharedClassService {
    private static final Logger LOGGER = CabinLoggerFactory.getLogger(SharedClassServiceImpl.class);
    private static final Object sentinel = new Object();
    private final AtomicBoolean preLoaded = new AtomicBoolean(false);
    private final ConcurrentMap<String, Class<?>> cachedClasses = new ConcurrentHashMap();
    private final ConcurrentMap<String, LibModule> classToModuleMap = new ConcurrentHashMap<String, LibModule>();
    private final Map<String, Map<LibModule, Object>> packageToModuleMap = new ConcurrentHashMap<String, Map<LibModule, Object>>();

    public void addSharedPackage(String packageName, Module module) {
        if (CabinStringUtil.isBlank((CharSequence)packageName)) {
            return;
        }
        Map modules = this.packageToModuleMap.computeIfAbsent(packageName, name -> new ConcurrentHashMap());
        modules.put((LibModule)module, sentinel);
    }

    public void preLoadAllSharedClasses() {
        if (this.preLoaded.compareAndSet(false, true)) {
            this.classToModuleMap.forEach((className, module) -> {
                Class<?> clazz = this.getClassFromModule((String)className, (LibModule)module);
                if (clazz == null && !className.contains("$")) {
                    throw new CabinRuntimeException(String.format("Could not load class %s which is exported by module %s from it!", className, module.getName()));
                }
            });
        }
    }

    public Class<?> getSharedClass(String className) {
        Class<?> clazz = this.getCachedClass(className);
        if (clazz != null) {
            return clazz;
        }
        clazz = this.getClassFromModuleAndCache(className);
        if (clazz != null) {
            return clazz;
        }
        int index = className.lastIndexOf(".");
        while (index > 0) {
            String packageName = className.substring(0, index);
            Map<LibModule, Object> modules = this.packageToModuleMap.get(packageName);
            if (modules != null && !modules.isEmpty()) {
                Class<?> prevLoadedClass = null;
                LibModule prevLoadedModule = null;
                for (LibModule libModule : modules.keySet()) {
                    clazz = this.getClassFromModule(className, libModule);
                    if (clazz == null) continue;
                    if (prevLoadedClass != null) {
                        throw new CabinRuntimeException(String.format("Class export conflicted, %s is exported by module %s and %s", className, prevLoadedModule.getName(), libModule.getName()));
                    }
                    prevLoadedClass = clazz;
                    prevLoadedModule = libModule;
                }
                if (prevLoadedClass != null) {
                    LOGGER.info("Trying to add class {} exported by Module {} to sharedClassService!", (Object)className, (Object)prevLoadedModule.getName());
                    Class prevClazz = this.cachedClasses.putIfAbsent(className, prevLoadedClass);
                    if (prevClazz != null && prevClazz != prevLoadedClass) {
                        throw new CabinRuntimeException(String.format("Class export conflicted, %s is exported by ClassLoader %s and %s", className, prevClazz.getClassLoader(), prevLoadedClass.getClassLoader()));
                    }
                    return prevLoadedClass;
                }
            }
            index = packageName.lastIndexOf(".");
        }
        return null;
    }

    public void addSharedClass(String className, Class<?> clazz) {
    }

    public void addSharedClass(String className, Module module) {
        if (className == null || module == null) {
            return;
        }
        Module prevModule = this.classToModuleMap.putIfAbsent(className, (LibModule)module);
        if (prevModule != null && prevModule != module) {
            throw new CabinRuntimeException(String.format("Class export conflicted, %s is exported by module %s and %s", className, prevModule.getName(), module.getName()));
        }
    }

    public Map<String, Class<?>> getSharedClassMap() {
        this.preLoadAllSharedClasses();
        return Collections.unmodifiableMap(this.cachedClasses);
    }

    public int getSharedClassCount() {
        return this.classToModuleMap.size();
    }

    public boolean containsClass(String className) {
        return this.classToModuleMap.containsKey(className);
    }

    private Class<?> getCachedClass(String className) {
        return (Class)this.cachedClasses.get(className);
    }

    private Class<?> getClassFromModuleAndCache(String className) {
        Class<?> result;
        LibModule module = (LibModule)this.classToModuleMap.get(className);
        if (module != null && (result = this.getClassFromModule(className, module)) != null) {
            this.cachedClasses.put(className, result);
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> getClassFromModule(String className, LibModule module) {
        try {
            Handler.setUseFastConnectionExceptions((boolean)true);
            LibModuleClassLoader libModuleClassLoader = (LibModuleClassLoader)module.getClassLoader();
            if (libModuleClassLoader != null) {
                Class<?> clazz = libModuleClassLoader.loadClassFromClasspath(className);
                return clazz;
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            Handler.setUseFastConnectionExceptions((boolean)false);
        }
        return null;
    }
}

