/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.support.test.junit;

import io.esastack.cabin.support.test.common.UnitTestLauncher;
import io.esastack.cabin.support.test.junit.CabinJUnit4Runner;
import io.esastack.cabin.support.test.junit.CabinSpringRunner;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.RunWith;
import org.junit.runner.notification.RunListener;

public class JUnitExecutionListener
extends RunListener {
    private static final String CABIN_JUNIT4_RUNNER = CabinJUnit4Runner.class.getName();
    private static final String CABIN_SPRING_RUNNER = CabinSpringRunner.class.getName();
    private static volatile RunListener instance;

    private JUnitExecutionListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RunListener getRunListener() {
        if (instance != null) return instance;
        Class<JUnitExecutionListener> clazz = JUnitExecutionListener.class;
        synchronized (JUnitExecutionListener.class) {
            if (instance != null) return instance;
            instance = new JUnitExecutionListener();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void testStarted(Description description) throws Exception {
        if (this.isCabinRunnerUsed(description)) {
            Thread.currentThread().setContextClassLoader(UnitTestLauncher.getTestBizClassLoader());
        } else {
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        }
        super.testStarted(description);
    }

    public void testFinished(Description description) throws Exception {
        super.testFinished(description);
        Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
    }

    protected boolean isCabinRunnerUsed(Description description) {
        RunWith runWith = description.getTestClass().getAnnotation(RunWith.class);
        if (runWith == null) {
            return false;
        }
        String runnerName = runWith.value().getName();
        return CABIN_JUNIT4_RUNNER.equals(runnerName) || CABIN_SPRING_RUNNER.equals(runnerName);
    }

    public void testRunFinished(Result result) throws Exception {
        super.testRunFinished(result);
        UnitTestLauncher.stop();
    }
}

