/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.support.test.common;

import io.esastack.cabin.common.exception.CabinRuntimeException;
import io.esastack.cabin.common.util.ClassLoaderUtils;
import io.esastack.cabin.support.bootstrap.CabinClasspathLauncher;
import java.lang.reflect.Method;
import java.net.URL;

public class UnitTestLauncher
extends CabinClasspathLauncher {
    private static volatile Object cabinContainer;
    private static volatile ClassLoader testBizClassLoader;

    private UnitTestLauncher(URL[] urls) {
        super("io.esastack.cabin.unit.test.fake.MainClass", urls);
    }

    public static synchronized void start() {
        if (cabinContainer == null) {
            try {
                UnitTestLauncher launcher = new UnitTestLauncher(ClassLoaderUtils.getApplicationClassPaths());
                cabinContainer = launcher.launch(new String[0]);
            }
            catch (Exception e) {
                throw new CabinRuntimeException("Failed to start UnitTestLauncher!", (Throwable)e);
            }
        }
    }

    public static synchronized void stop() {
        try {
            Method method = cabinContainer.getClass().getDeclaredMethod("stop", new Class[0]);
            method.invoke(cabinContainer, new Object[0]);
        }
        catch (Throwable ex) {
            throw new CabinRuntimeException("Failed to stop CabinContainer!", ex.getCause());
        }
    }

    public static synchronized boolean isStarted() {
        return cabinContainer != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClassLoader getTestBizClassLoader() {
        if (testBizClassLoader != null) return testBizClassLoader;
        Class<UnitTestLauncher> clazz = UnitTestLauncher.class;
        synchronized (UnitTestLauncher.class) {
            if (testBizClassLoader != null) return testBizClassLoader;
            try {
                Method method = cabinContainer.getClass().getDeclaredMethod("getBizModuleClassLoader", new Class[0]);
                testBizClassLoader = (ClassLoader)method.invoke(cabinContainer, new Object[0]);
            }
            catch (Throwable ex) {
                throw new RuntimeException("Failed to get TestBizClassLoader of CabinContainer", ex.getCause());
            }
            return testBizClassLoader;
        }
    }

    protected String findAppMainMethod() {
        return "unitTestMainMethod";
    }
}

