/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.cabin.support.test.junit;

import io.esastack.cabin.support.test.common.UnitTestLauncher;
import io.esastack.cabin.support.test.junit.JUnitExecutionListener;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.RunNotifier;

public class CabinSpringRunner
extends Runner
implements Filterable,
Sortable {
    private static final String SPRING_RUNNER = "org.springframework.test.context.junit4.SpringJUnit4ClassRunner";
    private final Runner delegate;

    public CabinSpringRunner(Class<?> testClass) {
        ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
        try {
            UnitTestLauncher.start();
            ClassLoader bizModuleClassLoader = UnitTestLauncher.getTestBizClassLoader();
            Thread.currentThread().setContextClassLoader(bizModuleClassLoader);
            Class<?> springRunnerClass = bizModuleClassLoader.loadClass(SPRING_RUNNER);
            Class<?> testClazz = bizModuleClassLoader.loadClass(testClass.getName());
            this.delegate = (Runner)springRunnerClass.getConstructor(Class.class).newInstance(testClazz);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTCCL);
        }
    }

    public Description getDescription() {
        return this.delegate.getDescription();
    }

    public void run(RunNotifier notifier) {
        ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(UnitTestLauncher.getTestBizClassLoader());
            notifier.addListener(JUnitExecutionListener.getRunListener());
            this.delegate.run(notifier);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTCCL);
        }
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        ((Filterable)this.delegate).filter(filter);
    }

    public void sort(Sorter sorter) {
        ((Sortable)this.delegate).sort(sorter);
    }
}

