/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.bridge;

import java.lang.reflect.Method;
import java.util.Map;
import javax.ejb.FinderException;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.bridge.FieldBridge;
import org.jboss.as.cmp.component.CmpEntityBeanComponentInstance;
import org.jboss.as.cmp.context.CmpEntityBeanContext;

public class EntityBridgeInvocationHandler {
    private final Map<String, BridgeInvoker> fieldMap;
    private final Map<Method, BridgeInvoker> selectorMap;

    public EntityBridgeInvocationHandler(Map<String, BridgeInvoker> fieldMap, Map<Method, BridgeInvoker> selectorMap) {
        this.fieldMap = fieldMap;
        this.selectorMap = selectorMap;
    }

    public Object invoke(CmpEntityBeanComponentInstance instance, Object proxy, Method method, Object[] args) throws FinderException {
        String methodName = method.getName();
        BridgeInvoker invoker = this.fieldMap.get(methodName);
        if (invoker == null && (invoker = this.selectorMap.get(method)) == null) {
            throw CmpMessages.MESSAGES.methodNoCmpAccessor(methodName);
        }
        try {
            return invoker.invoke(instance.getEjbContext(), method, args);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (FinderException e) {
            throw e;
        }
        catch (Exception e) {
            throw CmpMessages.MESSAGES.internalInvocationBridgeError(e);
        }
    }

    public static class FieldSetInvoker
    implements BridgeInvoker {
        private final FieldBridge field;

        public FieldSetInvoker(FieldBridge field) {
            this.field = field;
        }

        @Override
        public Object invoke(CmpEntityBeanContext ctx, Method method, Object[] args) {
            if (ctx == null) {
                throw CmpMessages.MESSAGES.homeMethodsCanNotAccessCmpFields(method.getName());
            }
            this.field.setValue(ctx, args[0]);
            return null;
        }
    }

    public static class FieldGetInvoker
    implements BridgeInvoker {
        private final FieldBridge field;

        public FieldGetInvoker(FieldBridge field) {
            this.field = field;
        }

        @Override
        public Object invoke(CmpEntityBeanContext ctx, Method method, Object[] args) {
            if (ctx == null) {
                throw CmpMessages.MESSAGES.homeMethodsCanNotAccessCmpFields(method.getName());
            }
            return this.field.getValue(ctx);
        }
    }

    public static interface BridgeInvoker {
        public Object invoke(CmpEntityBeanContext var1, Method var2, Object[] var3) throws Exception;
    }
}

