/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.ejbql;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.as.cmp.bridge.EntityBridge;

public final class Catalog {
    private final Map<String, EntityBridge> entityByAbstractSchemaName = new HashMap<String, EntityBridge>();
    private final Map<String, EntityBridge> entityByEJBName = new HashMap<String, EntityBridge>();
    private final Map<Class<?>, EntityBridge> entityByInterface = new HashMap();

    public synchronized void addEntity(EntityBridge entityBridge) {
        Class<?> local;
        this.entityByAbstractSchemaName.put(entityBridge.getAbstractSchemaName(), entityBridge);
        this.entityByEJBName.put(entityBridge.getEntityName(), entityBridge);
        Class<?> remote = entityBridge.getRemoteInterface();
        if (remote != null) {
            this.entityByInterface.put(remote, entityBridge);
        }
        if ((local = entityBridge.getLocalInterface()) != null) {
            this.entityByInterface.put(local, entityBridge);
        }
    }

    public EntityBridge getEntityByAbstractSchemaName(String abstractSchemaName) {
        return this.entityByAbstractSchemaName.get(abstractSchemaName);
    }

    public EntityBridge getEntityByInterface(Class intf) {
        return this.entityByInterface.get(intf);
    }

    public EntityBridge getEntityByEJBName(String ejbName) {
        return this.entityByEJBName.get(ejbName);
    }

    public int getEntityCount() {
        return this.entityByEJBName.size();
    }

    public Set getEJBNames() {
        return Collections.unmodifiableSet(this.entityByEJBName.keySet());
    }
}

