/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.keygen;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCIdentityColumnCreateCommand;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.JDBCUtil;
import org.jboss.as.cmp.jdbc.keygen.GetTCLAction;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityCommandMetaData;

public class JDBCMySQLCreateCommand
extends JDBCIdentityColumnCreateCommand {
    private String className;
    private String methodName;
    private Method method;
    private Method getUnderlyingStatement;

    @Override
    public void init(JDBCStoreManager manager) {
        super.init(manager);
        ClassLoader loader = GetTCLAction.getContextClassLoader();
        try {
            Class<?> psClass = loader.loadClass(this.className);
            this.method = psClass.getMethod(this.methodName, new Class[0]);
        }
        catch (ClassNotFoundException e) {
            throw CmpMessages.MESSAGES.failedToLoadDriverClass(this.className, e);
        }
        catch (NoSuchMethodException e) {
            throw CmpMessages.MESSAGES.driverDoesNotHaveMethod(this.className, this.methodName);
        }
        try {
            Class<?> wrapperClass = loader.loadClass("org.jboss.resource.adapter.jdbc.StatementAccess");
            this.getUnderlyingStatement = wrapperClass.getMethod("getUnderlyingStatement", new Class[0]);
        }
        catch (ClassNotFoundException e) {
            throw CmpMessages.MESSAGES.couldNotLoadStatementAccess(e);
        }
        catch (NoSuchMethodException e) {
            throw CmpMessages.MESSAGES.getUnderlyingStatementNotFound(e);
        }
    }

    @Override
    protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) {
        super.initEntityCommand(entityCommand);
        this.className = entityCommand.getAttribute("class-name");
        if (this.className == null) {
            this.className = "com.mysql.jdbc.PreparedStatement";
        }
        this.methodName = entityCommand.getAttribute("method");
        if (this.methodName == null) {
            this.methodName = "getGeneratedKeys";
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int executeInsert(int paramIndex, PreparedStatement ps, CmpEntityBeanContext ctx) throws SQLException {
        int rows = ps.executeUpdate();
        Statement stmt = ps;
        do {
            try {
                Object[] args = new Object[]{};
                stmt = (Statement)this.getUnderlyingStatement.invoke((Object)stmt, args);
            }
            catch (IllegalAccessException e) {
                SQLException ex = new SQLException("Failed to invoke getUnderlyingStatement");
                ex.initCause(e);
                throw ex;
            }
            catch (InvocationTargetException e) {
                SQLException ex = new SQLException("Failed to invoke getUnderlyingStatement");
                ex.initCause(e);
                throw ex;
            }
        } while (stmt != null && !this.method.getDeclaringClass().isInstance(stmt));
        ResultSet rs = null;
        try {
            rs = (ResultSet)this.method.invoke((Object)stmt, new Object[0]);
            if (!rs.next()) {
                throw CmpMessages.MESSAGES.getGeneratedKeysEmptyResultSet();
            }
            this.pkField.loadInstanceResults(rs, 1, ctx);
        }
        catch (RuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw CmpMessages.MESSAGES.errorExtractingGeneratedKey(e2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(rs);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(rs);
        return rows;
    }
}

